/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints.bases;

import com.robertx22.library_of_exile.registry.FilterListWrap;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarityType;
import com.robertx22.mine_and_slash.database.data.stats.types.loot.TreasureQuality;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.MapBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.SkillGemBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.bases.BlueprintPart;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import java.util.ArrayList;
import java.util.List;

public class GearRarityPart
extends BlueprintPart<GearRarity, ItemBlueprint> {
    GearRarity specialRar = null;
    public float chanceForHigherRarity = 0.0f;
    public boolean canRollUnique = false;
    public boolean canRollRuned = false;

    public GearRarityPart(ItemBlueprint blueprint) {
        super(blueprint);
        if (blueprint instanceof GearBlueprint) {
            this.canRollUnique = true;
            this.canRollRuned = true;
        }
    }

    public void setupChances(LootInfo info) {
        if (info.playerEntityData != null) {
            this.chanceForHigherRarity += info.playerEntityData.getUnit().getCalculatedStat(TreasureQuality.getInstance()).getValue();
        }
    }

    public List<GearRarity> getPossibleRarities() {
        if (this.blueprint instanceof SkillGemBlueprint) {
            return ExileDB.GearRarities().getFiltered(x -> this.blueprint.info.level >= x.min_lvl && !x.is_unique_item && x.getLowerRarity().isPresent() || x.hasHigherRarity());
        }
        if (this.blueprint instanceof MapBlueprint) {
            return ExileDB.GearRarities().getFiltered(x -> x.type == GearRarityType.NORMAL);
        }
        FilterListWrap filt = ExileDB.GearRarities().getFilterWrapped(x -> this.blueprint.info.level >= x.min_lvl);
        if (!this.canRollUnique) {
            filt = filt.of(x -> !x.is_unique_item);
        }
        if (!this.canRollRuned) {
            filt = filt.of(x -> !x.guid.equals("runeword"));
        }
        filt = filt.of(x -> this.blueprint.info.map_tier >= ((GearRarity)ExileDB.GearRarities().get((String)x.min_map_rarity_to_drop)).map_tiers.min);
        return filt.list;
    }

    private List<WeightedRarity> getWeightedRarities(List<GearRarity> possible) {
        ArrayList<WeightedRarity> weighted = new ArrayList<WeightedRarity>();
        for (GearRarity rar : possible) {
            float multiplier;
            int weight = rar.Weight();
            if (rar.guid.equals("unique") && this.canRollUnique) {
                multiplier = 1.0f + this.chanceForHigherRarity / 200.0f;
                multiplier = MathHelper.clamp(multiplier, 1.0f, 10.0f);
                weight = Math.round((float)weight * multiplier);
            }
            if (rar.guid.equals("runeword") && this.canRollRuned) {
                multiplier = 1.0f + this.chanceForHigherRarity / 200.0f;
                multiplier = MathHelper.clamp(multiplier, 1.0f, 10.0f);
                weight = Math.round((float)weight * multiplier);
            }
            weighted.add(new WeightedRarity(rar, weight));
        }
        return weighted;
    }

    private GearRarity weightedRandomRarity(List<WeightedRarity> weighted) {
        int totalWeight = weighted.stream().mapToInt(w -> w.weight).sum();
        if (totalWeight <= 0) {
            return weighted.get((int)0).rarity;
        }
        int roll = RandomUtils.RandomRange((int)1, (int)totalWeight);
        int cumulative = 0;
        for (WeightedRarity wr : weighted) {
            if (roll > (cumulative += wr.weight)) continue;
            return wr.rarity;
        }
        return weighted.get((int)0).rarity;
    }

    @Override
    protected GearRarity generateIfNull() {
        GearRarity higher;
        float chanceMulti;
        float chance;
        if (this.specialRar != null) {
            return this.specialRar;
        }
        List<GearRarity> possible = this.getPossibleRarities();
        List<WeightedRarity> weighted = this.getWeightedRarities(possible);
        GearRarity rar = this.weightedRandomRarity(weighted);
        if (rar.hasHigherRarity() && RandomUtils.roll((float)(chance = this.chanceForHigherRarity * (chanceMulti = MathHelper.clamp((float)(higher = rar.getHigherRarity()).Weight() / (float)rar.Weight(), 0.0f, 1.0f)))) && rar.hasHigherRarity() && this.getPossibleRarities().contains(rar.getHigherRarity()) && this.blueprint.info.level >= rar.getHigherRarity().min_lvl) {
            rar = rar.getHigherRarity();
        }
        return rar;
    }

    private static class WeightedRarity {
        public final GearRarity rarity;
        public final int weight;

        public WeightedRarity(GearRarity rarity, int weight) {
            this.rarity = rarity;
            this.weight = weight;
        }
    }
}

