/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints;

import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.loot_chest.base.LootChest;
import com.robertx22.mine_and_slash.database.data.loot_chest.base.LootChestData;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.ITypeBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.RarityItemBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.bases.LootChestPart;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LootChestBlueprint
extends RarityItemBlueprint
implements ITypeBlueprint {
    public LootChestPart type = new LootChestPart(this);
    public boolean useRarityKey = false;

    public LootChestBlueprint(LootInfo info) {
        super(info);
        this.rarity.chanceForHigherRarity = 75.0f;
    }

    @Override
    public ItemStack generate() {
        LootChestData data = this.createData();
        ItemStack stack = data.getLootChest().getChestItem(data).m_7968_();
        StackSaving.LOOT_CHEST.saveTo(stack, (Object)data);
        return stack;
    }

    public LootChestData createData() {
        LootChestData data = new LootChestData();
        data.num = 5;
        data.lvl = this.info.level;
        data.rar = ((GearRarity)this.rarity.get()).GUID();
        data.id = ((LootChest)this.type.get()).GUID();
        if (this.useRarityKey) {
            data.key = VanillaUTIL.REGISTRY.items().getKey((Object)((Item)RarityItems.RARITY_KEYS.get(data.rar).get())).toString();
        }
        return data;
    }

    @Override
    public void setType(String type) {
        this.type.set((LootChest)ExileDB.LootChests().get(type));
    }
}

