/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.config.forge.compat.CompatConfig;
import com.robertx22.mine_and_slash.database.data.rarities.MobRarity;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;

public class LootUtils {
    public static float getLevelDistancePunishmentMulti(int level, int playerLevel) {
        int leeway;
        if (playerLevel == level) {
            return 1.0f;
        }
        int num = Math.abs(playerLevel - level);
        if (num <= (leeway = ((Integer)ServerContainer.get().LEVEL_DISTANCE_PENALTY_LEEWAY.get()).intValue())) {
            return 1.0f;
        }
        float multi = (float)(1.0 - (double)(num -= leeway) * (Double)ServerContainer.get().LEVEL_DISTANCE_PENALTY_PER_LVL.get());
        return (float)Mth.m_14008_((double)multi, (double)((Double)ServerContainer.get().LEVEL_DISTANCE_PENALTY_MIN_MULTI.get()), (double)1.0);
    }

    public static float getMobHealthBasedLootMulti(LivingEntity entity) {
        float multi = 1.0f;
        float hp = CompatConfig.get().healthSystem().getOriginalMaxHealth(entity);
        MobRarity rar = Load.Unit((Entity)entity).getMobRarity();
        if (rar.forcesCustomHp()) {
            hp = rar.force_custom_hp;
        }
        multi += 1.0f + hp / 40.0f - 1.0f;
        if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            multi = (Integer)ServerContainer.get().MIN_SLIME_SIZE_FOR_LOOT.get() > slime.m_33632_() ? 0.0f : (slime.m_33632_() < 5 ? (multi *= 0.05f) : (multi *= 0.1f));
        }
        if (multi > 10.0f) {
            multi = 10.0f;
        }
        return multi;
    }

    public static int WhileRoll(float chance) {
        int amount = 0;
        while (chance > 0.0f) {
            float currentChance = chance;
            float maxChance = 75.0f;
            if (currentChance > maxChance) {
                currentChance = maxChance;
            }
            chance -= currentChance;
            if (!RandomUtils.roll((float)currentChance)) continue;
            ++amount;
        }
        return amount;
    }
}

