/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.itemstack;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.robertx22.library_of_exile.utils.ItemstackDataSaver;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class StackData<T> {
    ExileStack stack;
    private ItemstackDataSaver<T> saver;
    private Supplier<T> getterNon = () -> this.saver.loadFrom(this.stack.getStack());
    private Supplier<T> getter = Suppliers.memoize(this.getterNon);

    public StackData(ExileStack stack, ItemstackDataSaver<T> saver) {
        this.stack = stack;
        this.saver = saver;
        stack.map.put(this.getId(), this);
    }

    public T get() {
        return (T)this.getter.get();
    }

    public String getId() {
        return this.saver.GUID();
    }

    public T getOrCreate() {
        if (!this.has()) {
            this.set(this.saver.getConstructor().get());
        }
        return this.get();
    }

    public boolean has() {
        return this.saver.has(this.stack.getStack());
    }

    public void delete() {
        this.saver.removeFrom(this.stack.getStack());
    }

    public T createDefault() {
        return this.saver.getConstructor().get();
    }

    public boolean hasAndTrue(Predicate<T> p) {
        return this.has() && p.test(this.get());
    }

    public void set(T data) {
        this.saver.saveTo(this.stack.getStack(), data);
        this.resetGetterCache();
    }

    public void edit(Consumer<T> c) {
        c.accept(this.getOrCreate());
        this.save();
    }

    public void editIfHas(Consumer<T> c) {
        if (this.has()) {
            this.edit(c);
        }
    }

    public boolean setIfHas(T data) {
        if (this.has()) {
            this.set(data);
            return true;
        }
        return false;
    }

    public void save() {
        this.saver.saveTo(this.stack.getStack(), this.get());
        this.resetGetterCache();
    }

    public void resetGetterCache() {
        this.getter = Suppliers.memoize(this.getterNon);
    }
}

