/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.wiki.reworked;

import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.wiki.BestiaryEntry;
import com.robertx22.mine_and_slash.gui.wiki.BestiaryGroup;
import com.robertx22.mine_and_slash.gui.wiki.reworked.NewGroupButton;
import com.robertx22.mine_and_slash.gui.wiki.reworked.WikiEntryList;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.ClearFilterButton;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.FilterGroupButton;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.GroupFilterEntry;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.GroupFilterType;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class NewWikiScreen
extends Screen
implements INamedScreen {
    protected EditBox searchBox;
    private WikiEntryList list;
    public BestiaryEntry selectedEntry = null;
    public BestiaryGroup<?> group = BestiaryGroup.UNIQUE_GEAR;
    public HashMap<GroupFilterType, GroupFilterEntry> filter = new HashMap();
    public Checkbox searchTooltipsCheckbox;

    public NewWikiScreen() {
        super((Component)Words.WIKI.locName().m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
    }

    public GroupFilterEntry getFilter(GroupFilterType t) {
        return this.filter.getOrDefault(t, GroupFilterEntry.NONE);
    }

    public void setGroup(BestiaryGroup<?> g) {
        this.group = g;
        this.filter = new HashMap();
        this.m_7856_();
        this.list.forceFilter("");
    }

    public void setFilterGroup(GroupFilterType type, GroupFilterEntry f) {
        this.filter.put(type, f);
        this.list.forceFilter("");
    }

    private void refreshFilterButtons() {
        this.m_6702_().stream().filter(x -> x instanceof FilterGroupButton).collect(Collectors.toList()).forEach(e -> this.m_169411_((GuiEventListener)e));
        int x2 = 15;
        int y = 55;
        int spacing = FilterGroupButton.HEIGHT + 5;
        for (GroupFilterType t : GroupFilterType.ALL) {
            if (t.forGroup != this.group) continue;
            this.m_142416_((GuiEventListener)new FilterGroupButton(this, t, x2, y));
            this.m_142416_((GuiEventListener)new ClearFilterButton(this, t, x2 + FilterGroupButton.WIDTH + 5, y));
            y += spacing;
        }
    }

    public void m_86600_() {
        this.searchBox.m_94120_();
    }

    protected void m_7856_() {
        this.m_169413_();
        this.refreshFilterButtons();
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 22, 200, 20, this.searchBox, (Component)Component.m_237115_((String)"selectWorld.search"));
        this.searchBox.m_94151_(p_232980_ -> this.list.tryFilter((String)p_232980_));
        this.searchTooltipsCheckbox = new Checkbox(this.searchBox.m_252754_() + this.searchBox.m_5711_() + 5, this.searchBox.m_252907_(), 20, 20, (Component)Component.m_237113_((String)"Search Tooltips"), false){

            public void m_5691_() {
                super.m_5691_();
                String old = NewWikiScreen.this.searchBox.m_94155_();
                NewWikiScreen.this.searchBox.m_94144_(old + " ");
                NewWikiScreen.this.searchBox.m_94144_(old);
            }
        };
        this.m_142416_((GuiEventListener)this.searchTooltipsCheckbox);
        this.list = new WikiEntryList(this, this.f_96541_, this.f_96543_, this.f_96544_, 48, this.f_96544_ - 64, 36);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.list);
        this.setupGroupButtons();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        return super.m_7933_(pKeyCode, pScanCode, pModifiers) ? true : this.searchBox.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        this.searchBox.m_93692_(true);
        return this.searchBox.m_5534_(pCodePoint, pModifiers);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.list.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.searchBox.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    private void setupGroupButtons() {
        int spacing = (int)((float)NewGroupButton.SIZE * 1.25f);
        int total = 0;
        for (BestiaryGroup g : BestiaryGroup.getAll()) {
            total += spacing;
        }
        int gx = this.f_96543_ / 2 - total / 2;
        int gy = this.f_96544_ - 35;
        for (BestiaryGroup bestiaryGroup : BestiaryGroup.getAll()) {
            this.m_142416_((GuiEventListener)new NewGroupButton(this, bestiaryGroup, gx, gy));
            gx += spacing;
        }
    }

    public void m_7861_() {
        if (this.list != null) {
            // empty if block
        }
    }

    @Override
    public ResourceLocation iconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/main_hub/icons/wiki.png");
    }

    @Override
    public Words screenName() {
        return Words.WIKI;
    }
}

