/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.texts.textblocks;

import com.google.common.collect.ImmutableList;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AbstractTextBlock;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRequirement;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class RequirementBlock
extends AbstractTextBlock {
    private EntityData playerData = null;
    @Nullable
    public StatRequirement statRequirement;
    @Nullable
    public Integer levelRequirement;
    @Nullable
    public List<? extends Component> customComponents;

    public RequirementBlock() {
    }

    public RequirementBlock(@NotNull Integer levelRequirement) {
        this.levelRequirement = levelRequirement;
    }

    public RequirementBlock(@NotNull List<? extends Component> customComponents, String icon) {
        this.customComponents = customComponents.stream().map(x -> Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)icon).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).m_7220_((Component)x.m_6881_().m_130940_(ChatFormatting.GRAY))).toList();
    }

    public RequirementBlock setStatRequirement(@Nullable StatRequirement statRequirement) {
        this.statRequirement = statRequirement;
        return this;
    }

    public RequirementBlock setLevelRequirement(@Nullable Integer levelRequirement) {
        this.levelRequirement = levelRequirement;
        return this;
    }

    @Override
    public List<? extends Component> getAvailableComponents() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.playerData == null) {
            this.playerData = Load.Unit((Entity)ClientOnly.getPlayer());
        }
        if (this.levelRequirement != null) {
            boolean ifMetLevel;
            boolean bl = ifMetLevel = this.playerData.getLevel() >= this.levelRequirement;
            if (ifMetLevel) {
                builder.add((Object)Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)StatRequirement.CHECK_YES_ICON).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Itemtips.LEVEL_REQ.locName(this.levelRequirement).m_130944_(new ChatFormatting[0]).m_130940_(ChatFormatting.GRAY)));
            } else {
                builder.add((Object)Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)StatRequirement.NO_ICON).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Itemtips.LEVEL_REQ.locName(this.levelRequirement).m_130944_(new ChatFormatting[0]).m_130940_(ChatFormatting.DARK_GRAY)));
            }
            if (Screen.m_96639_()) {
                builder.add((Object)Chats.LEVEL_EXPLANATION.locName());
            }
        }
        if (this.statRequirement != null) {
            Optional.of(this.statRequirement).map(req -> req.GetTooltipString(this.levelRequirement, this.playerData)).ifPresent(x -> x.forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)));
        }
        if (this.customComponents != null) {
            builder.addAll(this.customComponents);
        }
        return builder.build();
    }

    @Override
    public ExileTooltips.BlockCategories getCategory() {
        return ExileTooltips.BlockCategories.REQUIREMENT;
    }
}

