/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.stat_gui;

import com.robertx22.library_of_exile.tooltip.ExileTooltipUtils;
import com.robertx22.library_of_exile.utils.GuiUtils;
import com.robertx22.library_of_exile.utils.RenderUtils;
import com.robertx22.library_of_exile.utils.TextUTIL;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.stats.IUsableStat;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.test.DataPackStatEffect;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.test.DatapackStat;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.IStatInfoButton;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatScreen;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class StatInfoButton
extends ImageButton
implements IStatInfoButton {
    public static int xSize = 20;
    public static int ySize = 20;
    private StatData stat;
    private StatInfoType type;
    private LivingEntity target;

    public StatInfoButton(StatScreen screen, StatInfoType type, StatData stat, int xPos, int yPos) {
        super(xPos, yPos, xSize, ySize, 0, 0, 0, SlashRef.guiId("stat_gui/info_button"), xSize, ySize, button -> {});
        this.type = type;
        this.stat = stat;
        this.target = screen.getTarget();
    }

    public void m_88315_(GuiGraphics gui, int x, int y, float ticks) {
        MutableComponent text;
        super.m_88315_(gui, x, y, ticks);
        if (this.stat == null || this.stat.GetStat() == null) {
            return;
        }
        if (this.m_198029_()) {
            List<MutableComponent> tooltip = this.type.getTooltip(this.stat);
            this.m_257544_(Tooltip.m_257550_((Component)TextUTIL.mergeList(tooltip)));
        }
        int iconX = 5;
        int iconY = 5;
        int numX = 10;
        int numY = 28;
        if (this.type.hasIcon) {
            RenderUtils.render16Icon((GuiGraphics)gui, (ResourceLocation)this.type.getIcon(), (int)(this.m_252754_() + iconX - 3), (int)(this.m_252907_() + iconY - 3));
        }
        if ((text = this.type.getRenderText(this.stat, Load.Unit((Entity)this.target))) != null) {
            GuiUtils.renderScaledText((GuiGraphics)gui, (int)(this.m_252754_() + numX), (int)(this.m_252907_() + numY), (float)0.8f, (String)text.getString(), (ChatFormatting)ChatFormatting.YELLOW);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum StatInfoType {
        CURRENT_VALUE("current_value", true){

            @Override
            public MutableComponent getRenderText(StatData data, EntityData unit) {
                String p = data.GetStat().IsPercent() ? "%" : "";
                return Component.m_237113_((String)(MMORPG.DECIMAL_FORMAT.format(data.getValue()) + p));
            }

            @Override
            public boolean shouldShow(StatData data) {
                return true;
            }

            @Override
            public List<MutableComponent> getTooltip(StatData data) {
                return Arrays.asList(Words.CurrentValueInfo.locName());
            }
        }
        ,
        DMG_MULTI("dmg_multi", true){

            @Override
            public MutableComponent getRenderText(StatData data, EntityData unit) {
                String p = "x" + MMORPG.DECIMAL_FORMAT.format(data.getMoreStatTypeMulti());
                return Component.m_237113_((String)p);
            }

            @Override
            public boolean shouldShow(StatData data) {
                return data.getMoreStatTypeMulti() != 1.0f && data.GetStat().getMultiUseType() == Stat.MultiUseType.MULTIPLICATIVE_DAMAGE;
            }

            @Override
            public List<MutableComponent> getTooltip(StatData data) {
                return Arrays.asList(Words.DmgMultiInfo.locName());
            }
        }
        ,
        USABLE_VALUE("usable_value", true){

            @Override
            public MutableComponent getRenderText(StatData data, EntityData unit) {
                Object object;
                Stat stat = data.GetStat();
                if (stat instanceof IUsableStat) {
                    IUsableStat u = (IUsableStat)((Object)stat);
                    object = NumberUtils.singleDigitFloat(u.getUsableValue(unit.getUnit(), (int)data.getValue(), unit.getLevel()) * 100.0f) + "%";
                } else {
                    object = "";
                }
                return Component.m_237113_((String)object);
            }

            @Override
            public boolean shouldShow(StatData data) {
                return data.GetStat() instanceof IUsableStat;
            }

            @Override
            public List<MutableComponent> getTooltip(StatData data) {
                return ExileTooltipUtils.splitLongText((MutableComponent)Words.UsableValueInfo.locName());
            }
        }
        ,
        MIN_VAL("min", true){

            @Override
            public boolean shouldShow(StatData data) {
                return true;
            }

            @Override
            public MutableComponent getRenderText(StatData data, EntityData unit) {
                return Component.m_237113_((String)(data.GetStat().getMinCapTooltipText() + (data.GetStat().IsPercent() ? "%" : "")));
            }

            @Override
            public List<MutableComponent> getTooltip(StatData data) {
                return Arrays.asList(Words.MincapInfo.locName());
            }
        }
        ,
        SOFTCAP("softcap", true){

            @Override
            public List<MutableComponent> getTooltip(StatData data) {
                return Arrays.asList(Words.SoftcapInfo.locName());
            }

            @Override
            public MutableComponent getRenderText(StatData data, EntityData unit) {
                return Component.m_237113_((String)(data.GetStat().getDefaultSoftCap() + (data.GetStat().IsPercent() ? "%" : "")));
            }

            @Override
            public boolean shouldShow(StatData data) {
                return data.GetStat().hasSoftCap();
            }
        }
        ,
        HARD_CAP("hardcap", true){

            @Override
            public boolean shouldShow(StatData data) {
                return true;
            }

            @Override
            public MutableComponent getRenderText(StatData data, EntityData unit) {
                return Component.m_237113_((String)(data.GetStat().getHardCapTooltipText() + (data.GetStat().IsPercent() ? "%" : "")));
            }

            @Override
            public List<MutableComponent> getTooltip(StatData data) {
                return Arrays.asList(Words.HardcapInfo.locName());
            }
        }
        ,
        INFO("info", true){

            @Override
            public boolean shouldShow(StatData data) {
                return true;
            }

            @Override
            public MutableComponent getRenderText(StatData data, EntityData unit) {
                return null;
            }

            @Override
            public List<MutableComponent> getTooltip(StatData data) {
                ArrayList<MutableComponent> t = new ArrayList<MutableComponent>();
                Stat stat = data.GetStat();
                t.add(Component.m_237113_((String)"Id: ").m_130946_(stat.GUID()));
                if (stat instanceof DatapackStat) {
                    DatapackStat d = (DatapackStat)stat;
                    for (DataPackStatEffect ef : d.effect) {
                        t.addAll(ef.getTooltip());
                    }
                }
                return t;
            }
        };

        public String id;
        public boolean hasIcon = false;

        private StatInfoType(String id, boolean hasIcon) {
            this.id = id;
            this.hasIcon = hasIcon;
        }

        public abstract boolean shouldShow(StatData var1);

        public abstract MutableComponent getRenderText(StatData var1, EntityData var2);

        public abstract List<MutableComponent> getTooltip(StatData var1);

        public ResourceLocation getIcon() {
            return SlashRef.guiId("stat_gui/info_button_icons/" + this.id);
        }
    }
}

