/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.spell;

import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsType;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.data.spell_school.SpellSchool;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.gui.bases.IAlertScreen;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.screens.ILeftRight;
import com.robertx22.mine_and_slash.gui.screens.spell.BigSchoolButton;
import com.robertx22.mine_and_slash.gui.screens.spell.LearnClassPointButton;
import com.robertx22.mine_and_slash.gui.screens.spell.LeftRightButton;
import com.robertx22.mine_and_slash.gui.screens.spell.PointsDisplayButton;
import com.robertx22.mine_and_slash.gui.screens.spell.SchoolButton;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SpellSchoolScreen
extends BaseScreen
implements INamedScreen,
ILeftRight,
IAlertScreen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("mmorpg", "textures/gui/asc_classes/background.png");
    static int sizeX = 250;
    static int sizeY = 233;
    Minecraft mc = Minecraft.m_91087_();
    public List<SpellSchool> schoolsInOrder = ExileDB.SpellSchools().getList();
    public int currentIndex = 0;
    public int maxIndex = ExileDB.SpellSchools().getSize() - 1;
    static int SLOT_SPACING = 21;
    SchoolButton LEFT_SCHOOL;
    SchoolButton RIGHT_SCHOOL;

    public SpellSchool currentSchool() {
        return this.schoolsInOrder.get(this.currentIndex);
    }

    public void setCurrent(SpellSchool sc) {
        for (int i = 0; i < this.schoolsInOrder.size(); ++i) {
            if (!sc.GUID().equals(this.schoolsInOrder.get(i).GUID())) continue;
            this.currentIndex = i;
            this.m_7856_();
            break;
        }
    }

    public SpellSchoolScreen() {
        super(sizeX, sizeY);
    }

    @Override
    public ResourceLocation iconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/main_hub/icons/spells.png");
    }

    @Override
    public Words screenName() {
        return Words.Classes;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        try {
            List all = Load.player((Player)this.mc.f_91074_).ascClass.school().stream().map(x -> (SpellSchool)ExileDB.SpellSchools().get(x)).collect(Collectors.toList());
            this.LEFT_SCHOOL = new SchoolButton(this, this.guiLeft + 41, this.guiTop + 13);
            this.RIGHT_SCHOOL = new SchoolButton(this, this.guiLeft + 185, this.guiTop + 13);
            this.publicAddButton(this.LEFT_SCHOOL);
            this.publicAddButton(this.RIGHT_SCHOOL);
            if (all.size() > 0) {
                this.LEFT_SCHOOL.school = (SpellSchool)all.get(0);
            }
            if (all.size() > 1) {
                this.RIGHT_SCHOOL.school = (SpellSchool)all.get(1);
            }
            this.m_142416_((GuiEventListener)new BigSchoolButton(this, this.guiLeft + 107, this.guiTop + 8));
            this.m_142416_((GuiEventListener)new LeftRightButton(this, this.guiLeft + 100 - LeftRightButton.xSize - 5, this.guiTop + 25 - LeftRightButton.ySize / 2, true));
            this.m_142416_((GuiEventListener)new LeftRightButton(this, this.guiLeft + 150 + 5, this.guiTop + 25 - LeftRightButton.ySize / 2, false));
            this.m_142416_((GuiEventListener)new PointsDisplayButton(PlayerPointsType.SPELLS, this.guiLeft + 8, this.guiTop + 206));
            this.m_142416_((GuiEventListener)new PointsDisplayButton(PlayerPointsType.PASSIVES, this.guiLeft + 148, this.guiTop + 206));
            this.currentSchool().perks.entrySet().forEach(e -> {
                PointData point = (PointData)e.getValue();
                Perk perk = (Perk)ExileDB.Perks().get((String)e.getKey());
                if (perk != null && ExileDB.Perks().isRegistered((String)e.getKey())) {
                    int x = this.guiLeft + 12 + point.x * SLOT_SPACING;
                    int y = this.guiTop + 178 - point.y * SLOT_SPACING;
                    this.m_142416_((GuiEventListener)new LearnClassPointButton(this, perk, x, y));
                }
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    public void mnsRenderBG(GuiGraphics gui) {
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        gui.m_280218_(BACKGROUND, this.mc.m_91268_().m_85445_() / 2 - sizeX / 2, this.mc.m_91268_().m_85446_() / 2 - sizeY / 2, 0, 0, sizeX, sizeY);
    }

    public void m_88315_(GuiGraphics gui, int x, int y, float ticks) {
        try {
            this.mnsRenderBG(gui);
            gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            gui.m_280163_(this.currentSchool().getBackgroundLoc(), this.guiLeft + 7, this.guiTop + 8, 93.0f, 36.0f, 93, 36, 93, 36);
            gui.m_280163_(this.currentSchool().getBackgroundLoc(), this.guiLeft + 150, this.guiTop + 8, 93.0f, 36.0f, 93, 36, 93, 36);
            super.m_88315_(gui, x, y, ticks);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void goLeft() {
        --this.currentIndex;
        if (this.currentIndex < 0) {
            this.currentIndex = this.maxIndex;
        }
        this.m_7856_();
    }

    @Override
    public void goRight() {
        ++this.currentIndex;
        if (this.currentIndex > this.maxIndex) {
            this.currentIndex = 0;
        }
        this.m_7856_();
    }

    @Override
    public boolean shouldAlert() {
        Player p = ClientOnly.getPlayer();
        return PlayerPointsType.SPELLS.hasFreePoints(p) || PlayerPointsType.PASSIVES.hasFreePoints(p);
    }
}

