/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.skill_tree;

import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import com.robertx22.library_of_exile.utils.Watch;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.data.stats.types.UnknownStat;
import com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.gui.bases.IAlertScreen;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.screens.skill_tree.BufferInfo;
import com.robertx22.mine_and_slash.gui.screens.skill_tree.VertexContainer;
import com.robertx22.mine_and_slash.gui.screens.skill_tree.buttons.PerkButton;
import com.robertx22.mine_and_slash.gui.screens.skill_tree.buttons.PerkConnectionRender;
import com.robertx22.mine_and_slash.gui.screens.skill_tree.buttons.PerkPointPair;
import com.robertx22.mine_and_slash.gui.screens.skill_tree.buttons.PerkScreenContext;
import com.robertx22.mine_and_slash.gui.screens.skill_tree.component.TipsWidget;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import java.awt.Point;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public abstract class SkillTreeScreen
extends BaseScreen
implements INamedScreen,
IAlertScreen {
    static ResourceLocation BIG_PANEL = new ResourceLocation("mmorpg", "textures/gui/skill_tree/bar.png");
    public TalentTree.SchoolType schoolType;
    public HashSet<PerkConnectionRender> buttonConnections = new HashSet();
    static ResourceLocation CON = SlashRef.id("textures/gui/skill_tree/skill_connection.png");
    public VertexContainer vertexContainer = new VertexContainer();
    private TipsWidget tips;
    public PointData pointClicked = new PointData(0, 0);
    public int mouseRecentlyClickedTicks = 0;
    int ticks = 0;
    int tick_count = 0;
    public int scrollX = 0;
    public int scrollY = 0;
    HashMap<AbstractWidget, PointData> originalButtonLocMap = new HashMap();
    HashMap<PointData, PerkButton> pointPerkButtonMap = new HashMap();
    public Minecraft mc = Minecraft.m_91087_();
    PlayerData playerData;
    public TalentTree school;
    private static int SEARCH_WIDTH = 100;
    private static int SEARCH_HEIGHT = 14;
    public static EditBox SEARCH = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, SEARCH_WIDTH, SEARCH_HEIGHT, (Component)Component.m_237115_((String)"fml.menu.mods.search"));
    public float zoom;
    public float targetZoom;
    public PerkScreenContext ctx;
    String msstring;
    static ResourceLocation BACKGROUND = SlashRef.guiId("skill_tree/background");

    private void renderConnection(GuiGraphics graphics, PerkConnectionRender renderer) {
        graphics.m_280168_().m_85836_();
        PerkPointPair pair = renderer.pair();
        PerkButton button1 = this.pointPerkButtonMap.get(pair.data1());
        PerkButton button2 = this.pointPerkButtonMap.get(pair.data2());
        PerkScreenContext ctx = new PerkScreenContext(this);
        double xadd = (float)button1.perk.getType().size / 2.0f;
        double yadd = (float)button1.perk.getType().size / 2.0f;
        double connectionX = (double)button1.m_252754_() + xadd;
        double connectionY = (double)button1.m_252907_() + yadd;
        graphics.m_280168_().m_85837_((connectionX -= (double)ctx.scrollX) + (double)this.scrollX, (connectionY -= (double)ctx.scrollY) + (double)this.scrollY, 0.0);
        float rotation = this.getAngleBetweenButtons(button1, button2);
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252961_(rotation));
        int length = (int)this.getDistanceBetweenButtons(button1, button2);
        int off = 0;
        if (renderer.connection() == Perk.Connection.LINKED) {
            off = 0;
        }
        if (renderer.connection() == Perk.Connection.POSSIBLE) {
            off = 6;
        }
        if (renderer.connection() == Perk.Connection.BLOCKED) {
            off = 11;
        }
        HashMultimap<ResourceLocation, BufferInfo> map = this.vertexContainer.map;
        map.put((Object)SlashRef.id("textures/gui/skill_tree/skill_connection.png"), (Object)BufferInfo.of(0.0f, -3.0f, length, 6, -5.0f, 0.0f, (float)off, length, 6, 50, 16, graphics.m_280168_().m_85850_().m_252922_()));
        graphics.m_280168_().m_85849_();
    }

    protected float getDistanceBetweenButtons(PerkButton button1, PerkButton button2) {
        float x1 = (float)button1.m_252754_() + (float)button1.m_5711_() / 2.0f;
        float y1 = (float)button1.m_252907_() + (float)button1.m_93694_() / 2.0f;
        float x2 = (float)button2.m_252754_() + (float)button2.m_5711_() / 2.0f;
        float y2 = (float)button2.m_252907_() + (float)button2.m_93694_() / 2.0f;
        return this.getDistanceBetweenPoints(x1, y1, x2, y2);
    }

    protected float getDistanceBetweenPoints(float x1, float y1, float x2, float y2) {
        return Mth.m_14116_((float)((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
    }

    protected float getAngleBetweenButtons(PerkButton button1, PerkButton button2) {
        float x1 = (float)button1.m_252754_() + (float)button1.m_5711_() / 2.0f;
        float y1 = (float)button1.m_252907_() + (float)button1.m_93694_() / 2.0f;
        float x2 = (float)button2.m_252754_() + (float)button2.m_5711_() / 2.0f;
        float y2 = (float)button2.m_252907_() + (float)button2.m_93694_() / 2.0f;
        return this.getAngleBetweenPoints(x1, y1, x2, y2);
    }

    protected float getAngleBetweenPoints(float x1, float y1, float x2, float y2) {
        return (float)Mth.m_14136_((double)(y2 - y1), (double)(x2 - x1));
    }

    public SkillTreeScreen(TalentTree.SchoolType type) {
        super(Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
        this.playerData = Load.player((Player)this.mc.f_91074_);
        this.targetZoom = this.zoom = 0.3f;
        this.ctx = new PerkScreenContext(this);
        this.msstring = "";
        this.schoolType = type;
    }

    public boolean m_6348_(double x, double y, int ticks) {
        this.mouseRecentlyClickedTicks = 25;
        return super.m_6348_(x, y, ticks);
    }

    public static int sizeX() {
        return Minecraft.m_91087_().m_91268_().m_85441_();
    }

    public static int sizeY() {
        return Minecraft.m_91087_().m_91268_().m_85442_();
    }

    private void renderConnections(GuiGraphics gui) {
        for (PerkConnectionRender con : this.buttonConnections) {
            this.renderConnection(gui, con);
        }
    }

    public boolean shouldRender(int x, int y, PerkScreenContext ctx) {
        return x >= ctx.offsetX + 10 && (float)x < (float)ctx.offsetX + (float)SkillTreeScreen.sizeX() * ctx.getZoomMulti() - 10.0f && y >= ctx.offsetY + 10 && (float)y < (float)ctx.offsetY + (float)SkillTreeScreen.sizeY() * ctx.getZoomMulti() - 10.0f;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.goToCenter();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public static boolean searchFocused() {
        if (SEARCH != null) {
            return SEARCH.m_93696_();
        }
        return false;
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        SEARCH.m_93692_(true);
        return SEARCH.m_5534_(pCodePoint, pModifiers);
    }

    public void m_86600_() {
        SEARCH.m_94120_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        try {
            SEARCH.m_93692_(false);
            SEARCH.m_94190_(true);
            this.school = (TalentTree)ExileDB.TalentTrees().getFilterWrapped((Predicate<TalentTree>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$init$0(com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree ), (Lcom/robertx22/mine_and_slash/database/data/talent_tree/TalentTree;)Z)((SkillTreeScreen)this)).list.get(0);
            this.refreshButtons();
            this.tips = new TipsWidget(0, 0, 10, 10, (Component)Gui.TALENT_SCREEN_SEARCH_TIPS.locName(Gui.TALENT_SCREEN_SEARCH_KEYWORD_ALL.locName().m_130940_(ChatFormatting.GOLD), Gui.TALENT_SCREEN_SEARCH_KEYWORD_GAME_CHANGER.locName().m_130940_(ChatFormatting.GOLD)));
            this.m_7787_((GuiEventListener)this.tips);
            this.goToCenter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addButtonPublic(AbstractWidget b) {
        this.m_142416_((GuiEventListener)b);
    }

    private void addConnections() {
        this.buttonConnections = new HashSet(3000);
        HashSet integers = new HashSet(3000);
        this.m_6702_().forEach(b -> {
            if (b instanceof PerkButton) {
                PerkButton pb = (PerkButton)((Object)b);
                Set<PointData> connections = this.school.calcData.connections.getOrDefault(pb.point, Collections.EMPTY_SET);
                for (PointData p : connections) {
                    PerkButton sb = this.pointPerkButtonMap.get(p);
                    PerkPointPair pair = new PerkPointPair(pb.point, sb.point);
                    if (integers.contains(pair)) continue;
                    Perk.Connection con = this.playerData.talents.getConnection(this.school, sb.point, pb.point);
                    PerkConnectionRender result = new PerkConnectionRender(pair, con);
                    this.buttonConnections.add(result);
                    integers.add(pair);
                }
            }
        });
    }

    public void refreshButtons() {
        this.originalButtonLocMap.clear();
        this.pointPerkButtonMap.clear();
        this.m_169413_();
        this.scrollX = 0;
        this.scrollY = 0;
        for (Map.Entry<PointData, String> e : this.school.calcData.perks.entrySet()) {
            Perk perk = (Perk)ExileDB.Perks().get(e.getValue());
            if (perk == null) {
                perk = (Perk)ExileDB.Perks().get(new UnknownStat().GUID());
            }
            try {
                Point pos = this.getPosForPoint(e.getKey(), perk);
                int x = pos.x;
                int y = pos.y;
                PerkButton button = new PerkButton(this, this.playerData, this.school, e.getKey(), perk, x, y);
                button.perkid = e.getValue();
                this.newButton((AbstractWidget)button);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.addConnections();
        this.m_7787_((GuiEventListener)SEARCH);
    }

    private Point getPosForPoint(PointData point, Perk perk) {
        float halfx = (float)this.mc.m_91268_().m_85445_() / 2.0f;
        float halfy = (float)this.mc.m_91268_().m_85446_() / 2.0f;
        float x = (point.x - this.school.calcData.center.x) * PerkButton.SPACING;
        float y = (point.y - this.school.calcData.center.y) * PerkButton.SPACING;
        float tx = (int)(halfx + (x -= (float)perk.getType().size / 2.0f));
        float ty = (int)(halfy + (y -= (float)perk.getType().size / 2.0f));
        return new Point((int)tx, (int)ty);
    }

    public void goToCenter() {
        this.scrollX = 0;
        this.scrollY = 0;
    }

    private void newButton(AbstractWidget b) {
        this.addButtonPublic(b);
        this.originalButtonLocMap.put(b, new PointData(b.m_252754_(), b.m_252907_()));
        if (b instanceof PerkButton) {
            this.pointPerkButtonMap.put(((PerkButton)b).point, (PerkButton)b);
        }
    }

    public void m_7379_() {
        super.m_7379_();
        this.resetZoom();
        SEARCH.m_93692_(false);
    }

    public void m_7861_() {
        super.m_7861_();
        this.resetZoom();
    }

    private void resetZoom() {
        this.targetZoom = this.zoom = 1.0f;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.targetZoom -= 0.1f;
        }
        if (scroll > 0.0) {
            this.targetZoom += 0.1f;
        }
        this.zoom = this.targetZoom = Mth.m_14036_((float)this.targetZoom, (float)0.15f, (float)1.0f);
        return true;
    }

    public PointData getZoomedPosition(PointData pos) {
        return new PointData((int)(this.zoom / (float)pos.x), (int)(this.zoom / (float)pos.y));
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.scrollX = (int)((double)this.scrollX + (double)(1.0f / this.zoom) * deltaX);
        this.scrollY = (int)((double)this.scrollY + (double)(1.0f / this.zoom) * deltaY);
        this.scrollY = Mth.m_14045_((int)this.scrollY, (int)-3333, (int)3333);
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void m_88315_(GuiGraphics gui, int x, int y, float ticks) {
        Watch watch = new Watch();
        this.ctx = new PerkScreenContext(this);
        --this.mouseRecentlyClickedTicks;
        SkillTreeScreen.renderBackgroundDirt(gui, this, 0);
        this.zoom = Mth.m_14179_((float)((Double)ClientConfigs.getConfig().SKILL_TREE_ZOOM_SPEED.get()).floatValue(), (float)this.zoom, (float)this.targetZoom);
        this.renderPanels(gui);
        this.tips.m_88315_(gui, x, y, ticks);
        gui.m_280168_().m_85841_(this.zoom, this.zoom, this.zoom);
        try {
            float addx = (1.0f / this.zoom - 1.0f) * (float)this.f_96543_ / 2.0f;
            float addy = (1.0f / this.zoom - 1.0f) * (float)this.f_96544_ / 2.0f;
            for (Renderable e : this.f_169369_) {
                PerkButton b;
                if (!(e instanceof PerkButton) || !this.originalButtonLocMap.containsKey((Object)(b = (PerkButton)e))) continue;
                int xp = (int)((float)this.originalButtonLocMap.get((Object)((Object)b)).x + addx + (float)this.scrollX);
                int yp = (int)((float)this.originalButtonLocMap.get((Object)((Object)b)).y + addy + (float)this.scrollY);
                b.m_252865_(xp);
                b.m_253211_(yp);
            }
            this.renderConnections(gui);
            ticks += 1.0f;
            if (this.mouseRecentlyClickedTicks > 1) {
                this.addConnections();
                this.mouseRecentlyClickedTicks = 0;
            }
            super.m_88315_(gui, x, y, ticks);
            this.vertexContainer.draw((MultiBufferSource)gui.m_280091_());
            this.vertexContainer.refresh();
            ++this.tick_count;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        gui.m_280168_().m_85841_(1.0f / this.zoom, 1.0f / this.zoom, 1.0f / this.zoom);
        this.msstring = watch.getPrint();
    }

    public static void renderBackgroundDirt(GuiGraphics gui, Screen screen, int vOffset) {
        Minecraft mc = Minecraft.m_91087_();
        int i = 32;
        gui.m_280398_(BACKGROUND, 0, 0, -10, 0.0f, 0.0f, mc.f_91080_.f_96543_, mc.f_91080_.f_96544_, 32, 32);
    }

    private void renderPanels(GuiGraphics gui) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        int BG_WIDTH = 256;
        int BG_HEIGHT = 22;
        int xp = (int)((float)mc.m_91268_().m_85445_() / 2.0f - (float)BG_WIDTH / 2.0f);
        int yp = 0;
        gui.m_280218_(BIG_PANEL, xp, yp, 0, 0, BG_WIDTH, BG_HEIGHT);
        RenderSystem.depthFunc((int)515);
        int savedx = xp;
        int savedy = yp;
        int points = this.schoolType.getPointType().getFreePoints((Player)mc.f_91074_);
        MutableComponent text = Gui.TALENT_POINTS.locName().m_130946_("" + points);
        int yx = 4;
        gui.m_280430_(mc.f_91062_, (Component)text, savedx + 15, yx, ChatFormatting.YELLOW.m_126665_().intValue());
        text = Gui.TALENT_RESET_POINTS.locName().m_130946_(String.valueOf(this.schoolType.getPointType().getResetPoints((Player)mc.f_91074_)));
        gui.m_280430_(mc.f_91062_, (Component)text, savedx + BG_WIDTH - mc.f_91062_.m_92852_((FormattedText)text) - 15, yx, ChatFormatting.YELLOW.m_126665_().intValue());
        int tx = savedx + BG_WIDTH;
        tx = (tx - savedx) / 2 + savedx - SEARCH_WIDTH / 2;
        Objects.requireNonNull(mc.f_91062_);
        SEARCH.m_252865_(tx);
        SEARCH.m_253211_(yx -= (SEARCH_HEIGHT - 9) / 2);
        SEARCH.m_88315_(gui, 0, 0, 0.0f);
        this.tips.m_252865_(tx + SEARCH.m_5711_() - this.tips.m_5711_() - 2);
        this.tips.m_253211_(yx + (SEARCH.m_93694_() - this.tips.m_93694_()) / 2);
        if (MMORPG.RUN_DEV_TOOLS) {
            MutableComponent debug = Component.m_237113_((String)("Widgets: " + this.m_6702_().size() + " - " + this.msstring));
            gui.m_280430_(mc.f_91062_, (Component)debug, savedx + 277, yx, ChatFormatting.GREEN.m_126665_().intValue());
        }
    }

    private /* synthetic */ boolean lambda$init$0(TalentTree x) {
        return x.getSchool_type().equals((Object)this.schoolType);
    }
}

