/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays.spell_hotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayConfig;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayType;
import com.robertx22.mine_and_slash.gui.overlays.spell_hotbar.SpellOnHotbarRender;
import com.robertx22.mine_and_slash.mmorpg.registers.client.SpellKeybind;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ChatUtils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SpellHotbarOverlay {
    Minecraft mc = Minecraft.m_91087_();

    public static ResourceLocation getHotbarTex(OverlayType type) {
        return SpellHotbarOverlay.hotbarTex(type == OverlayType.SPELL_HOTBAR_HORIZONTAL, (Boolean)ClientConfigs.getConfig().HOTBAR_SWAPPING.get(), SpellKeybind.IS_ON_SECONd_HOTBAR ? 2 : 1);
    }

    static ResourceLocation hotbarTex(Boolean horizontal, Boolean swap, Integer swapnum) {
        Object swaptex = swap != false ? "_swap" + swapnum : "";
        String horizontaltex = horizontal != false ? "_horizontal" : "";
        return new ResourceLocation("mmorpg", "textures/gui/spells/hotbar/hotbar" + (String)swaptex + horizontaltex + ".png");
    }

    public void onHudRender(GuiGraphics gui, OverlayConfig config, OverlayType type) {
        try {
            if (this.mc.f_91066_.f_92063_) {
                return;
            }
            if (this.mc.f_91074_.m_5833_()) {
                return;
            }
            if (ChatUtils.isChatOpen() && type == OverlayType.SPELL_HOTBAR_VERTICAL) {
                return;
            }
            if (Load.player((Player)this.mc.f_91074_) == null) {
                return;
            }
            RenderSystem.enableBlend();
            int x = config.getPos().x;
            int y = config.getPos().y;
            int spells = 8;
            ArrayList<SpellOnHotbarRender> list = new ArrayList<SpellOnHotbarRender>();
            for (int i = 0; i < spells; ++i) {
                int place = i;
                int xp = x + 3;
                int yp = y + 3;
                list.add(new SpellOnHotbarRender(type == OverlayType.SPELL_HOTBAR_HORIZONTAL, place, gui, xp, yp));
            }
            if (((Boolean)ClientConfigs.getConfig().HIDE_SPELL_HOTBAR_WHEN_NO_SPELL.get()).booleanValue()) {
                if (list.stream().anyMatch(spell -> spell.spell != null)) {
                    this.renderHotbarBackground(type, type.getSize(), gui, x, y);
                    list.forEach(SpellOnHotbarRender::render);
                }
            } else {
                this.renderHotbarBackground(type, type.getSize(), gui, x, y);
                list.forEach(SpellOnHotbarRender::render);
            }
            RenderSystem.disableBlend();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderHotbarBackground(OverlayType type, PointData size, GuiGraphics gui, int x, int y) {
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        ResourceLocation hotbar = SpellHotbarOverlay.getHotbarTex(type);
        gui.m_280218_(hotbar, x, y, 0, 0, size.x, size.y);
    }
}

