/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays;

import com.robertx22.library_of_exile.utils.GuiUtils;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayConfig;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayType;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffectInstanceData;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class EffectsOverlay {
    public static void render(GuiGraphics gui, boolean horizontal) {
        Player p = ClientOnly.getPlayer();
        OverlayConfig config = ClientConfigs.getConfig().getOverlayConfig(OverlayType.EFFECTS_VERTICAL);
        int x = config.getPos().x;
        int y = config.getPos().y;
        int size = 16;
        int spacing = 18;
        int bgX = 18;
        int bgY = 24;
        for (Map.Entry<String, ExileEffectInstanceData> en : Load.Unit((Entity)p).getStatusEffectsData().exileMap.entrySet()) {
            if (en.getValue().shouldRemove()) continue;
            ExileEffect eff = (ExileEffect)ExileDB.ExileEffects().get(en.getKey());
            gui.m_280411_(SlashRef.guiId("effect/effect_bg"), x, y, bgX, bgY, 0.0f, 0.0f, bgX, bgY, bgX, bgY);
            gui.m_280411_(eff.getTexture(), x + 1, y + 1, size, size, 0.0f, 0.0f, size, size, size, size);
            gui.m_280411_(SlashRef.guiId("effect/effect_overlay"), x, y, bgX, bgY, 0.0f, 0.0f, bgX, bgY, bgX, bgY);
            GuiUtils.renderScaledText((GuiGraphics)gui, (int)(x + 15), (int)(y + 5), (float)0.6f, (String)("" + en.getValue().stacks), (ChatFormatting)ChatFormatting.WHITE);
            String text = en.getValue().getDurationString();
            GuiUtils.renderScaledText((GuiGraphics)gui, (int)(x + 10), (int)(y + 21), (float)0.6f, (String)text, (ChatFormatting)ChatFormatting.YELLOW);
            if (horizontal) {
                x += bgX;
                continue;
            }
            y += bgY;
        }
    }
}

