/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.inv_gui;

import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.inv_gui.GuiItemData;
import com.robertx22.mine_and_slash.gui.inv_gui.InvGuiGrid;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.GuiAction;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.GuiConfigToggle;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.PickSpellAction;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellCastingData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.entity.player.Player;

public class GuiInventoryGrids {
    public static InvGuiGrid ofSelectableSpells(Player p, int slot) {
        GuiAction.regenActionMap();
        ArrayList<GuiItemData> list = new ArrayList<GuiItemData>();
        PickSpellAction.SLOT = slot;
        for (SpellCastingData.InsertedSpell spell : Load.player((Player)p).spellCastingData.spells) {
            list.add(new GuiItemData(new PickSpellAction(spell.getData().getSpell())));
        }
        return InvGuiGrid.ofList(list);
    }

    public static InvGuiGrid ofSalvageConfig() {
        GuiAction.regenActionMap();
        HashMap map = new HashMap();
        List rarities = ExileDB.GearRarities().getList();
        rarities.sort(Comparator.comparingInt(x -> x.item_tier));
        for (ToggleAutoSalvageRarity.SalvageType type : ToggleAutoSalvageRarity.SalvageType.values()) {
            if (!map.containsKey((Object)type)) {
                map.put(type, new ArrayList());
            }
            for (GearRarity rar : rarities) {
                ((List)map.get((Object)type)).add(new GuiItemData(new ToggleAutoSalvageRarity(type, rar)));
            }
        }
        ArrayList<List<GuiItemData>> lists = new ArrayList<List<GuiItemData>>();
        for (Map.Entry en : map.entrySet()) {
            lists.add((List)en.getValue());
        }
        return InvGuiGrid.ofYRowLists(lists);
    }

    public static InvGuiGrid ofConfigs() {
        GuiAction.regenActionMap();
        ArrayList<GuiItemData> lists = new ArrayList<GuiItemData>();
        for (PlayerConfigData.Config v : Arrays.stream(PlayerConfigData.Config.values()).filter(x -> !x.isDebug).collect(Collectors.toList())) {
            lists.add(new GuiItemData(new GuiConfigToggle(v)));
        }
        return InvGuiGrid.ofYRowLists(Arrays.asList(lists));
    }
}

