/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.buttons;

import com.robertx22.library_of_exile.utils.TextUTIL;
import com.robertx22.library_of_exile.wrappers.ExileText;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.stats.IUsableStat;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.gui.screens.character_screen.MainHubScreen;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;

public class CharacterStatsButtons
extends ImageButton {
    public static int BUTTON_SIZE_X = 16;
    public static int BUTTON_SIZE_Y = 16;
    MainHubScreen.StatType type;

    public CharacterStatsButtons(MainHubScreen.StatType type, int xPos, int yPos) {
        super(xPos, yPos, BUTTON_SIZE_X, BUTTON_SIZE_Y, 0, 0, BUTTON_SIZE_Y, type.getIcon(), button -> {});
        this.type = type;
    }

    protected ClientTooltipPositioner m_262860_() {
        return DefaultTooltipPositioner.f_262752_;
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        this.setModTooltip();
        super.m_88315_(gui, mouseX, mouseY, delta);
    }

    public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        gui.m_280163_(this.type.getIcon(), this.m_252754_(), this.m_252907_(), (float)BUTTON_SIZE_X, (float)BUTTON_SIZE_X, BUTTON_SIZE_X, BUTTON_SIZE_X, BUTTON_SIZE_X, BUTTON_SIZE_X);
    }

    public void setModTooltip() {
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        Minecraft mc = Minecraft.m_91087_();
        for (List<Stat> list : MainHubScreen.STAT_MAP.get((Object)this.type)) {
            if (!tooltip.isEmpty()) {
                tooltip.add(ExileText.emptyLine().get());
            }
            for (Stat stat : list) {
                tooltip.add(stat.locName().m_130946_(": " + CharacterStatsButtons.getStatString(stat, Load.Unit((Entity)mc.f_91074_))));
            }
        }
        this.m_257544_(Tooltip.m_257550_((Component)TextUTIL.mergeList(tooltip)));
    }

    public static String getStatString(Stat stat, EntityData unitdata) {
        StatData data = unitdata.getUnit().getCalculatedStat(stat);
        Object str = "";
        String v1 = NumberUtils.formatForTooltip(data.getValue());
        if (stat instanceof IUsableStat) {
            IUsableStat usable = (IUsableStat)((Object)stat);
            String value = NumberUtils.format(usable.getUsableValue(unitdata.getUnit(), (int)data.getValue(), unitdata.getLevel()) * 100.0f);
            str = (String)str + value + "%";
            str = stat.IsPercent() ? (String)str + " (" + v1 + "%)" : (String)str + " (" + v1 + ")";
        } else {
            str = (String)str + v1;
            if (stat.IsPercent()) {
                str = (String)str + "%";
            }
        }
        return str;
    }

    public static String getHubStatString(Stat stat, EntityData unitdata) {
        StatData data = unitdata.getUnit().getCalculatedStat(stat);
        Object str = "";
        String v1 = NumberUtils.formatForTooltip(data.getValue());
        if (stat instanceof IUsableStat) {
            IUsableStat usable = (IUsableStat)((Object)stat);
            String value = NumberUtils.format(usable.getUsableValue(unitdata.getUnit(), (int)data.getValue(), unitdata.getLevel()) * 100.0f);
            str = (String)str + value;
        } else {
            str = (String)str + v1;
        }
        return str;
    }
}

