/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.event_hooks.player;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.mine_and_slash.capability.player.data.Backpacks;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.gui.screens.character_screen.MainHubScreen;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatScreen;
import com.robertx22.mine_and_slash.mmorpg.registers.client.KeybindsRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.client.SpellKeybind;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ChatUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LookUtils;
import com.robertx22.mine_and_slash.vanilla_mc.packets.OpenEntityStatsRequestPacket;
import com.robertx22.mine_and_slash.vanilla_mc.packets.QuickUsePotionPacket;
import com.robertx22.mine_and_slash.vanilla_mc.packets.UnsummonPacket;
import com.robertx22.mine_and_slash.vanilla_mc.packets.backpack.OpenBackpackPacket;
import com.robertx22.mine_and_slash.vanilla_mc.packets.spells.TellServerToCastSpellPacket;
import java.util.List;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.settings.KeyModifier;

public class OnKeyPress {
    public static int cooldown = 0;
    private static Stack<SpellKeybind> spellKeysPressed = new Stack();
    private static int lastSpellNumber = -1;
    private static int spellPacketResendTimer = 0;

    public static void onEndTick(Minecraft mc) {
        if (mc.f_91074_ == null) {
            return;
        }
        if (ChatUtils.wasChatOpenRecently()) {
            return;
        }
        OnKeyPress.updateSpellInputs();
        if (cooldown > 0) {
            --cooldown;
            return;
        }
        if (KeybindsRegister.HUB_SCREEN_KEY.m_90857_()) {
            mc.m_91152_((Screen)new MainHubScreen());
            cooldown = 10;
        } else if (KeybindsRegister.OPEN_MASTER_BACKPACK.m_90857_()) {
            Packets.sendToServer((MyPacket)new OpenBackpackPacket(Backpacks.BackpackType.GEARS));
            cooldown = 10;
        } else if (KeybindsRegister.SHOW_ENTITY_STATS.m_90857_() && OnKeyPress.showEntityStats(mc)) {
            cooldown = 10;
        }
        if (KeybindsRegister.QUICK_DRINK_POTION.m_90859_()) {
            Packets.sendToServer((MyPacket)new QuickUsePotionPacket());
        }
        if (KeybindsRegister.HOTBAR_SWAP.m_90857_()) {
            SpellKeybind.IS_ON_SECONd_HOTBAR = !SpellKeybind.IS_ON_SECONd_HOTBAR;
            cooldown = 5;
        }
        if (KeybindsRegister.UNSUMMON.m_90857_()) {
            Packets.sendToServer((MyPacket)new UnsummonPacket());
            cooldown = 3;
        }
    }

    private static boolean showEntityStats(Minecraft mc) {
        LivingEntity pickedEntity = OnKeyPress.pickEntity(mc);
        if (pickedEntity == null) {
            return false;
        }
        if (pickedEntity instanceof Player) {
            mc.m_91152_((Screen)new StatScreen(pickedEntity));
        } else {
            Packets.sendToServer((MyPacket)new OpenEntityStatsRequestPacket((Entity)pickedEntity));
        }
        return true;
    }

    private static LivingEntity pickEntity(Minecraft mc) {
        Entity cameraEntity = mc.m_91288_();
        if (cameraEntity == null) {
            return null;
        }
        List<LivingEntity> results = LookUtils.getLivingEntityLookedAt(cameraEntity, 100.0, true);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    private static boolean checkToAddSpellKeyPress(SpellKeybind key) {
        if (key.key.m_90859_()) {
            if (!spellKeysPressed.contains(key)) {
                spellKeysPressed.add(key);
            }
            while (key.key.m_90859_()) {
            }
            return true;
        }
        return false;
    }

    private static void updateSpellInputs() {
        int number;
        List<SpellKeybind> keys = SpellKeybind.ALL;
        if (((Boolean)ClientConfigs.getConfig().HOTBAR_SWAPPING.get()).booleanValue()) {
            keys = SpellKeybind.FIRST_HOTBAR_KEYS;
        }
        spellKeysPressed.removeIf(key -> !key.key.m_90857_());
        for (SpellKeybind key2 : keys) {
            if (key2.key.getKeyModifier() != KeyModifier.NONE || !OnKeyPress.checkToAddSpellKeyPress(key2)) continue;
            break;
        }
        for (SpellKeybind key2 : keys) {
            if (key2.key.getKeyModifier() == KeyModifier.NONE || !OnKeyPress.checkToAddSpellKeyPress(key2)) continue;
            break;
        }
        if (!spellKeysPressed.empty()) {
            number = ((SpellKeybind)spellKeysPressed.lastElement()).getIndex();
            if (SpellKeybind.IS_ON_SECONd_HOTBAR) {
                number += 4;
            }
        } else {
            number = -1;
        }
        if (number == lastSpellNumber) {
            if (number == -1) {
                return;
            }
            if (spellPacketResendTimer > 0) {
                --spellPacketResendTimer;
                return;
            }
        }
        Packets.sendToServer((MyPacket)new TellServerToCastSpellPacket(number));
        lastSpellNumber = number;
        spellPacketResendTimer = 2;
    }
}

