/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.event_hooks.my_events;

import com.robertx22.mine_and_slash.capability.bases.EntityGears;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.characters.PlayerStats;
import com.robertx22.mine_and_slash.database.data.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class OnEntityTick {
    public static void onTick(LivingEntity entity) {
        try {
            if (entity.m_9236_().f_46443_) {
                return;
            }
            EntityData data = Load.Unit((Entity)entity);
            if (data == null) {
                return;
            }
            if (data.isSummon()) {
                data.summonedPetData.tick(entity);
            }
            --data.immuneTicks;
            data.ailments.onTick(entity);
            data.getStatusEffectsData().tick(entity);
            data.getCooldowns().onTicksPass(1);
            if (entity.f_19797_ % 20 == 0) {
                data.leech.onSecondUseLeeches(data);
            }
            if (entity instanceof Player) {
                OnEntityTick.checkGearChanged(entity);
                if (entity.f_19797_ % 100 == 0) {
                    Player p = (Player)entity;
                    for (Map.Entry<String, ResourceLocation> set : PlayerStats.REGISTERED_STATS.entrySet()) {
                        int max = Math.round(data.getUnit().getCalculatedStat(set.getKey()).getValue());
                        p.m_7166_(Stats.f_12988_.m_12902_((Object)PlayerStats.REGISTERED_STATS.get(set.getKey())));
                        p.m_6278_(Stats.f_12988_.m_12902_((Object)PlayerStats.REGISTERED_STATS.get(set.getKey())), max);
                    }
                }
            } else {
                MobRarity rar = Load.Unit((Entity)entity).getMobRarity();
                if (!rar.spells.isEmpty()) {
                    for (String id : rar.spells) {
                        Spell spell = (Spell)ExileDB.Spells().get(id);
                        if (data.getCooldowns().isOnCooldown(id)) continue;
                        SpellCastContext ctx = new SpellCastContext(entity, 0, spell);
                        spell.cast(ctx);
                        int cd = ctx.spell.getCooldownTicks(ctx);
                        ctx.data.getCooldowns().setOnCooldown(ctx.spell.GUID(), cd);
                    }
                }
            }
            data.equipmentCache.onTick();
            data.sync.onTickTrySync((Entity)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkGearChanged(LivingEntity entity) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        if (entity.m_21224_()) {
            return;
        }
        EntityData data = Load.Unit((Entity)entity);
        EntityGears gears = data.getCurrentGears();
        boolean gearChanged = false;
        boolean weaponchanged = false;
        for (EquipmentSlot s : EquipmentSlot.values()) {
            ItemStack before;
            ItemStack now = entity.m_6844_(s);
            if (now != (before = gears.get(s))) {
                if (s == EquipmentSlot.MAINHAND) {
                    weaponchanged = true;
                } else {
                    gearChanged = true;
                }
            }
            gears.put(s, now);
        }
        if (gearChanged) {
            data.equipmentCache.GEAR.setDirty();
        }
        if (weaponchanged) {
            data.equipmentCache.WEAPON.setDirty();
        }
    }
}

