/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.event_hooks.my_events;

import com.robertx22.mine_and_slash.a_libraries.curios.MyCuriosUtils;
import com.robertx22.mine_and_slash.capability.DirtySync;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.omen.OmenData;
import com.robertx22.mine_and_slash.database.data.omen.OmenSet;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.util.AttackInformation;
import com.robertx22.mine_and_slash.event_hooks.my_events.LazyClass;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.unit.GearData;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.MiscStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CachedEntityStats {
    private List<GearData> gear = new ArrayList<GearData>();
    private GearData weapon;
    public LivingEntity entity;
    public AttackInformation attackInfo;
    private StatContext statusEffects;
    LazyClass<EntityData> unitdata = new LazyClass<EntityData>(() -> Load.Unit((Entity)this.entity));
    public DirtySync STAT_CALC = new DirtySync("stat_calc", x -> this.unitdata.get().recalcStats_DONT_CALL());
    public DirtySync GEAR = new DirtySync("gear", x -> {
        this.recalcGears();
        if (x instanceof Player) {
            Player p = (Player)x;
            Load.player((Player)p).cachedStats.ENCHANT_COMPAT.setDirty();
            Load.player((Player)p).cachedStats.omenStats = null;
            Load.player(p).recalcOmensFilled();
            OmenData omen = Load.player(p).getOmen();
            if (omen != null) {
                Load.player((Player)p).cachedStats.omenStats = new MiscStatCtx(new OmenSet(omen).getStats(p));
            }
        }
        this.recalcPlayerStuff();
        this.STAT_CALC.setDirty();
    });
    public DirtySync WEAPON = new DirtySync("weapon", x -> {
        this.recalcWeapon();
        if (x instanceof Player) {
            Player p = (Player)x;
            Load.player((Player)p).cachedStats.ENCHANT_COMPAT.setDirty();
        }
        this.STAT_CALC.setDirty();
    });
    public DirtySync STATUS = new DirtySync("status_effects", x -> {
        this.recalcStatusEffects();
        this.STAT_CALC.setDirty();
    });

    public CachedEntityStats(LivingEntity entity) {
        this.entity = entity;
    }

    public GearData getWeapon() {
        return this.weapon;
    }

    public Optional<GearData> getWeaponOpt() {
        return this.weapon != null ? Optional.of(this.weapon) : Optional.empty();
    }

    private void recalcPlayerStuff() {
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            Load.player((Player)p).cachedStats.setAllDirty();
        }
    }

    public void setAllDirty() {
        this.GEAR.setDirty();
        this.WEAPON.setDirty();
        this.STATUS.setDirty();
        this.recalcPlayerStuff();
    }

    public void onTick() {
        this.GEAR.onTickTrySync((Entity)this.entity);
        this.WEAPON.onTickTrySync((Entity)this.entity);
        this.STATUS.onTickTrySync((Entity)this.entity);
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            Load.player((Player)p).cachedStats.tick();
        }
        this.STAT_CALC.onTickTrySync((Entity)this.entity);
    }

    public List<GearData> getGear() {
        ArrayList<GearData> all = new ArrayList<GearData>(this.gear);
        if (this.weapon != null) {
            all.add(this.weapon);
        }
        return all;
    }

    public StatContext getStatusEffectStats() {
        if (this.statusEffects == null) {
            this.recalcStatusEffects();
        }
        return this.statusEffects;
    }

    private void recalcStatusEffects() {
        this.statusEffects = this.unitdata.get().getStatusEffectsData().getStats(this.entity);
    }

    private void recalcWeapon() {
        this.weapon = null;
        Boolean hasWeapon = false;
        EquipmentSlot slot = EquipmentSlot.MAINHAND;
        GearData data = this.getDataFor(slot, this.entity, this.unitdata.get());
        data.gear = (GearItemData)StackSaving.GEARS.loadFrom(this.entity.m_21205_());
        if (data.gear != null && data.gear.GetBaseGearType().isWeapon()) {
            hasWeapon = true;
        }
        if (!hasWeapon.booleanValue()) {
            if (this.attackInfo != null && this.attackInfo.weaponData != null) {
                this.weapon = new GearData(this.attackInfo.weapon, EquipmentSlot.MAINHAND, this.unitdata.get());
                hasWeapon = true;
            }
        } else {
            this.weapon = data;
        }
        if (this.weapon != null && !this.weapon.isUsableBy(this.unitdata.get())) {
            this.weapon = null;
        }
    }

    private void recalcGears() {
        ArrayList<GearData> list = new ArrayList<GearData>();
        List<EquipmentSlot> ARMORS = Arrays.asList(EquipmentSlot.CHEST, EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.HEAD, EquipmentSlot.OFFHAND);
        for (EquipmentSlot slot : ARMORS) {
            GearData data = this.getDataFor(slot, this.entity, this.unitdata.get());
            list.add(data);
        }
        if (this.entity instanceof Player) {
            MyCuriosUtils.getAllSlots((Player)this.entity).forEach(x -> {
                GearData data = new GearData((ItemStack)x, null, this.unitdata.get());
                list.add(data);
            });
        }
        this.gear = list.stream().filter(x -> x.isUsableBy(this.unitdata.get())).collect(Collectors.toList());
    }

    GearData getDataFor(EquipmentSlot slot, LivingEntity en, EntityData data) {
        ItemStack stack = en.m_6844_(slot);
        return new GearData(stack, slot, data);
    }
}

