/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.registrators;

import com.robertx22.library_of_exile.registry.ExileRegistryInit;
import com.robertx22.library_of_exile.registry.register_info.ExileRegistrationInfo;
import com.robertx22.mine_and_slash.aoe_data.database.ailments.Ailment;
import com.robertx22.mine_and_slash.aoe_data.database.ailments.AilmentSpeed;
import com.robertx22.mine_and_slash.aoe_data.database.exile_effects.adders.ModEffects;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.data.profession.all.Professions;
import com.robertx22.mine_and_slash.database.data.profession.stat.DoubleDropChance;
import com.robertx22.mine_and_slash.database.data.profession.stat.ProfCategoryDropStat;
import com.robertx22.mine_and_slash.database.data.profession.stat.ProfExp;
import com.robertx22.mine_and_slash.database.data.profession.stat.TripleDropChance;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.effects.defense.MaxElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.JewelEffect;
import com.robertx22.mine_and_slash.database.data.stats.types.JewelSocketStat;
import com.robertx22.mine_and_slash.database.data.stats.types.MaxAllSpellLevels;
import com.robertx22.mine_and_slash.database.data.stats.types.MaxSpellLevel;
import com.robertx22.mine_and_slash.database.data.stats.types.MaximumChargesStat;
import com.robertx22.mine_and_slash.database.data.stats.types.UnknownStat;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentChance;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentDuration;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentEffectStat;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentProcStat;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentReceiveChance;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentResistance;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AllAilmentDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.HitDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.core_stats.AllAttributes;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.Armor;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.ArmorPenetration;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.BlockChance;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.DamageShield;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.DodgeRating;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.SpellDodge;
import com.robertx22.mine_and_slash.database.data.stats.types.gear_base.GearDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.gear_base.GearDefense;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.BonusAttackDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.BonusFlatElementalDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.BonusPhysicalAsElemental;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.ElementalPenetration;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.PhysicalDamageTakenAs;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.PhysicalDamageTakenAsRandom;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.PhysicalToElement;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.PhysicalToRandom;
import com.robertx22.mine_and_slash.database.data.stats.types.loot.TreasureQuality;
import com.robertx22.mine_and_slash.database.data.stats.types.loot.TreasureQuantity;
import com.robertx22.mine_and_slash.database.data.stats.types.misc.BonusExp;
import com.robertx22.mine_and_slash.database.data.stats.types.misc.DamageTakenToMana;
import com.robertx22.mine_and_slash.database.data.stats.types.misc.ExtraMobDropsStat;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.FullSwingDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.SkillDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.WeaponDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.DamageAbsorbedByMana;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.RegeneratePercentStat;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.blood.Blood;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.blood.BloodUser;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.blood.HealthRestorationToBlood;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.Energy;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.EnergyRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.Health;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.HealthRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShield;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShieldHeal;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShieldRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.Mana;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.ManaRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.special.BattlemageUser;
import com.robertx22.mine_and_slash.database.data.stats.types.spirit.AuraCapacity;
import com.robertx22.mine_and_slash.database.data.stats.types.spirit.AuraEffect;
import com.robertx22.mine_and_slash.database.data.stats.types.summon.GolemSpellChance;
import com.robertx22.mine_and_slash.database.data.stats.types.summon.SummonHealth;
import com.robertx22.mine_and_slash.database.empty_entries.EmptyStat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.tags.all.SpellTags;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IGenerated;
import java.util.ArrayList;

public class StatsRegister
implements ExileRegistryInit {
    public void registerAll() {
        ArrayList<Stat> All = new ArrayList<Stat>();
        ArrayList<Stat> generated = new ArrayList<Stat>(){
            {
                this.add(AilmentSpeed.INSTANCE);
                this.add(new MaxAllSpellLevels());
                this.add(new MaxSpellLevel(SpellTags.area));
                this.add(new SummonHealth());
                for (Ailment ailment : ExileDB.Ailments().getList()) {
                    this.add(new AilmentChance(ailment));
                    this.add(new AilmentReceiveChance(ailment));
                    this.add(new AilmentDamage(ailment));
                    this.add(new AilmentDuration(ailment));
                    this.add(new AilmentEffectStat(ailment));
                    this.add(new AilmentResistance(ailment));
                    this.add(new AilmentProcStat(ailment));
                }
                for (String prof : Professions.ALL) {
                    for (Profession.DropCategory cat : Profession.DropCategory.values()) {
                        this.add(new ProfCategoryDropStat(cat, prof));
                    }
                    this.add(new DoubleDropChance(prof));
                    this.add(new TripleDropChance(prof));
                    this.add(new ProfExp(prof));
                }
                this.add(EmptyStat.getInstance());
                this.add(JewelSocketStat.getInstance());
                this.add(new MaximumChargesStat(ModEffects.ENDURANCE_CHARGE));
                this.add(new BonusPhysicalAsElemental(Elements.Elemental));
                this.add(new MaxElementalResist(Elements.Elemental));
                this.add(GolemSpellChance.getInstance());
                this.add(GearDefense.getInstance());
                this.add(GearDamage.getInstance());
                this.add(RegeneratePercentStat.HEALTH);
                this.add(RegeneratePercentStat.MANA);
                this.add(RegeneratePercentStat.ENERGY);
                this.add(RegeneratePercentStat.MAGIC_SHIELD);
                this.add(ArmorPenetration.getInstance());
                this.add(AllAilmentDamage.getInstance());
                this.add(HitDamage.getInstance());
                this.add(BlockChance.getInstance());
                this.add(AuraCapacity.getInstance());
                this.add(AuraEffect.getInstance());
                this.add(JewelEffect.getInstance());
                this.add(WeaponDamage.getInstance());
                this.add(FullSwingDamage.getInstance());
                this.add(MagicShield.getInstance());
                this.add(MagicShieldRegen.getInstance());
                this.add(MagicShieldHeal.getInstance());
                this.add(SpellDodge.getInstance());
                this.add(TreasureQuality.getInstance());
                this.add(TreasureQuantity.getInstance());
                this.add(new BonusAttackDamage(Elements.Physical));
                this.add(new ElementalResist(Elements.Physical));
                this.add(new ElementalPenetration(Elements.Physical));
                this.add(new PhysicalToElement(Elements.Physical));
                this.add(PhysicalToRandom.getInstance());
                this.add(new PhysicalDamageTakenAs(Elements.Physical));
                this.add(PhysicalDamageTakenAsRandom.getInstance());
                this.add(new BonusFlatElementalDamage(Elements.Physical));
                this.add(AllAttributes.getInstance());
                this.add(SkillDamage.getInstance());
                this.add(ExtraMobDropsStat.getInstance());
                this.add(BonusExp.getInstance());
                this.add(DamageTakenToMana.getInstance());
                this.add(BattlemageUser.getInstance());
                this.add(new UnknownStat());
                this.add(DamageAbsorbedByMana.getInstance());
                this.add(HealthRestorationToBlood.getInstance());
                this.add(Blood.getInstance());
                this.add(BloodUser.getInstance());
                this.add(Health.getInstance());
                this.add(HealthRegen.getInstance());
                this.add(Mana.getInstance());
                this.add(ManaRegen.getInstance());
                this.add(EnergyRegen.getInstance());
                this.add(Energy.getInstance());
                this.add(Armor.getInstance());
                this.add(DodgeRating.getInstance());
                this.add(DamageShield.getInstance());
            }
        };
        for (Stat stat : generated) {
            if (stat instanceof IGenerated) {
                for (Stat gen : ((IGenerated)((Object)stat)).generateAllPossibleStatVariations()) {
                    All.add(gen);
                }
                continue;
            }
            All.add(stat);
        }
        All.forEach(x -> x.registerToExileRegistry((ExileRegistrationInfo)MMORPG.HARDCODED_REGISTRATION_INFO));
    }
}

