/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.value_calc;

import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.WeaponDamage;
import com.robertx22.mine_and_slash.database.data.value_calc.LeveledValue;
import com.robertx22.mine_and_slash.database.data.value_calc.MaxLevelProvider;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ScalingCalc {
    public String stat;
    public LeveledValue multi;

    public Stat getStat() {
        return (Stat)ExileDB.Stats().get(this.stat);
    }

    public ScalingCalc() {
    }

    public ScalingCalc(Stat stat, LeveledValue multi) {
        this.stat = stat.GUID();
        this.multi = multi;
    }

    public LeveledValue getMulti() {
        return this.multi;
    }

    public int getMultiAsPercent(LivingEntity en, MaxLevelProvider provider) {
        return (int)(this.multi.getValue(en, provider) * 100.0f);
    }

    public Component GetStatTooltipString(LivingEntity en, MaxLevelProvider provider) {
        return Gui.SPELL_DAMAGE_PROPORTION.locName(this.getMultiAsPercent(en, provider), this.getStat().getMutableIconNameFormat());
    }

    public Component GetTargetStatTooltipString(LivingEntity en, MaxLevelProvider provider) {
        return Gui.TARGET_SPELL_DAMAGE_PROPORTION.locName(this.getMultiAsPercent(en, provider), this.getStat().getMutableIconNameFormat());
    }

    public List<Component> getTooltipFor(float multi, float value, MutableComponent statname, Elements el) {
        ArrayList<Component> list = new ArrayList<Component>();
        Object eleStr = "";
        if (el != null) {
            eleStr = el.format + el.icon;
        }
        if (statname != null) {
            list.add((Component)Component.m_237113_((String)(ChatFormatting.RED + "Scales with " + (int)(multi * 100.0f) + "% " + (String)eleStr + " ")).m_7220_((Component)statname).m_130946_(" (" + value + ")"));
        }
        return list;
    }

    public int getCalculatedValue(LivingEntity en, MaxLevelProvider provider) {
        float multi = this.getMulti().getValue(en, provider);
        int val = (int)(multi * Load.Unit((Entity)en).getUnit().getCalculatedStat(this.stat).getValue());
        if (this.getStat() == WeaponDamage.getInstance() && !(en instanceof Player)) {
            val = (int)((float)val + Load.Unit((Entity)en).getMobBaseDamage());
        }
        return val;
    }
}

