/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.types.generated;

import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.StatScaling;
import com.robertx22.mine_and_slash.database.data.stats.effects.base.BaseDamageEffect;
import com.robertx22.mine_and_slash.database.data.stats.layers.StatLayers;
import com.robertx22.mine_and_slash.database.data.stats.priority.StatPriority;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AttackType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.EffectSides;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class PhysicalToRandom
extends Stat {
    private static final List<Elements> ELEMENTS = Arrays.asList(Elements.Fire, Elements.Cold, Elements.Nature, Elements.Shadow);
    private static final Random RANDOM = new Random();

    public PhysicalToRandom() {
        this.scaling = StatScaling.NONE;
        this.statEffect = new Effect();
        this.min = 0.0f;
    }

    public static PhysicalToRandom getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public Elements getElement() {
        return Elements.Physical;
    }

    @Override
    public String locDescForLangFile() {
        return "Converts a percentage of physical hit damage to a random element.";
    }

    @Override
    public String locNameForLangFile() {
        return "Physical to Random Element Damage";
    }

    public String GUID() {
        return "phys_to_random";
    }

    @Override
    public boolean IsPercent() {
        return true;
    }

    @Override
    public String locDescLangFileGUID() {
        return "mmorpg.stat_desc.turn_phys_to_random";
    }

    private class Effect
    extends BaseDamageEffect {
        private Effect() {
        }

        @Override
        public StatPriority GetPriority() {
            return StatPriority.Damage.DAMAGE_LAYERS;
        }

        @Override
        public EffectSides Side() {
            return EffectSides.Source;
        }

        @Override
        public DamageEvent activate(DamageEvent effect, StatData data, Stat stat) {
            Elements randomElement = ELEMENTS.get(RANDOM.nextInt(ELEMENTS.size()));
            effect.getLayer(StatLayers.Offensive.DAMAGE_CONVERSION, EventData.NUMBER, this.Side()).convertDamage(randomElement, (int)data.getValue());
            return effect;
        }

        @Override
        public boolean canActivate(DamageEvent effect, StatData data, Stat stat) {
            return effect.GetElement() == Elements.Physical && effect.getAttackType().equals((Object)AttackType.hit);
        }
    }

    private static class SingletonHolder {
        private static final PhysicalToRandom INSTANCE = new PhysicalToRandom();

        private SingletonHolder() {
        }
    }
}

