/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.types.generated;

import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.StatScaling;
import com.robertx22.mine_and_slash.database.data.stats.effects.base.BaseDamageEffect;
import com.robertx22.mine_and_slash.database.data.stats.priority.StatPriority;
import com.robertx22.mine_and_slash.database.data.stats.types.ElementalStat;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AttackType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.EffectSides;
import java.util.ArrayList;
import java.util.List;

public class BonusAttackDamage
extends ElementalStat {
    @Override
    public List<Stat> generateAllPossibleStatVariations() {
        ArrayList<Stat> list = new ArrayList<Stat>();
        Elements.getAllSingle().forEach(x -> list.add(this.newGeneratedInstance((Elements)((Object)x))));
        return list;
    }

    public BonusAttackDamage(Elements element) {
        super(element);
        this.scaling = StatScaling.NORMAL;
        this.group = Stat.StatGroup.ELEMENTAL;
        this.statEffect = new Effect();
        this.format = element.format.m_126666_();
        this.icon = element.icon;
    }

    @Override
    public Stat newGeneratedInstance(Elements element) {
        return new BonusAttackDamage(element);
    }

    @Override
    public boolean IsPercent() {
        return false;
    }

    @Override
    public String locDescLangFileGUID() {
        return "mmorpg.stat_desc.ele_atk_dmg";
    }

    @Override
    public String locNameForLangFile() {
        return this.getElement().dmgName + " DMG on Basic ATK";
    }

    @Override
    public String locDescForLangFile() {
        return "Adds x element damage on basic attacks only";
    }

    public String GUID() {
        return this.getElement().guidName + "_weapon_damage";
    }

    private static class Effect
    extends BaseDamageEffect {
        private Effect() {
        }

        @Override
        public StatPriority GetPriority() {
            return StatPriority.Damage.BEFORE_DAMAGE_LAYERS;
        }

        @Override
        public EffectSides Side() {
            return EffectSides.Source;
        }

        @Override
        public DamageEvent activate(DamageEvent effect, StatData data, Stat stat) {
            effect.addBonusEleDmg(stat.getElement(), data.getValue(), this.Side());
            return effect;
        }

        @Override
        public boolean canActivate(DamageEvent effect, StatData data, Stat stat) {
            return effect.data.isBasicAttack() && effect.data.getAttackType() == AttackType.hit;
        }
    }
}

