/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.types.defense;

import com.robertx22.library_of_exile.util.UNICODE;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.stats.IUsableStat;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.StatScaling;
import com.robertx22.mine_and_slash.database.data.stats.effects.base.BaseDamageEffect;
import com.robertx22.mine_and_slash.database.data.stats.priority.StatPriority;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.tags.all.SpellTags;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AttackType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.EffectSides;
import net.minecraft.ChatFormatting;
import net.minecraft.util.Mth;

public class DodgeRating
extends Stat
implements IUsableStat {
    public static String GUID = "dodge";

    public static DodgeRating getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String locDescForLangFile() {
        return "Chance to ignore attack damage";
    }

    private DodgeRating() {
        this.min = 0.0f;
        this.scaling = StatScaling.NORMAL;
        this.group = Stat.StatGroup.MAIN;
        this.statEffect = new Effect();
        this.icon = UNICODE.STAR;
        this.format = ChatFormatting.DARK_GREEN.m_126666_();
    }

    public String GUID() {
        return GUID;
    }

    @Override
    public Elements getElement() {
        return Elements.Physical;
    }

    @Override
    public boolean IsPercent() {
        return false;
    }

    @Override
    public String locNameForLangFile() {
        return "Dodge Rating";
    }

    @Override
    public float getMaxMulti() {
        return 0.8f;
    }

    @Override
    public float valueNeededToReachMaximumPercentAtLevelOne() {
        return 100.0f;
    }

    private static class SingletonHolder {
        private static final DodgeRating INSTANCE = new DodgeRating();

        private SingletonHolder() {
        }
    }

    private static class Effect
    extends BaseDamageEffect {
        private Effect() {
        }

        @Override
        public StatPriority GetPriority() {
            return StatPriority.Damage.HIT_PREVENTION;
        }

        @Override
        public EffectSides Side() {
            return EffectSides.Target;
        }

        @Override
        public DamageEvent activate(DamageEvent effect, StatData data, Stat stat) {
            effect.data.setHitAvoided(EventData.IS_DODGED);
            return effect;
        }

        @Override
        public boolean canActivate(DamageEvent effect, StatData data, Stat stat) {
            if (effect.GetElement() != Elements.Physical) {
                return false;
            }
            if (effect.getAttackType() != AttackType.hit) {
                return false;
            }
            if (effect.isSpell() && effect.getSpell().config.tags.contains(SpellTags.magic)) {
                return false;
            }
            DodgeRating dodge = (DodgeRating)stat;
            float totalDodge = Mth.m_14036_((float)(data.getValue() - effect.data.getNumber((String)EventData.ACCURACY).number), (float)0.0f, (float)2.1474836E9f);
            float chance = dodge.getUsableValue(effect.targetData.getUnit(), (int)totalDodge, effect.sourceData.getLevel()) * 100.0f;
            return effect.getAttackType().isAttack() && RandomUtils.roll((float)chance);
        }
    }
}

