/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.layers;

import com.robertx22.mine_and_slash.database.data.stats.layers.StatLayer;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.EffectSides;
import java.util.HashMap;
import java.util.Map;

public class StatLayerData {
    public EffectSides side = EffectSides.Source;
    private String layer = "";
    public String numberID = "";
    private float number = 0.0f;
    public Conversion conversion = null;
    public Conversion damageTakenAs = null;
    public AdditionalConversion additionalConversion = null;

    public StatLayerData(String layer, String numberID, float number, EffectSides side) {
        this.layer = layer;
        this.numberID = numberID;
        this.number = number;
        this.side = side;
    }

    public void convertAdditional(Elements to, int perc) {
        this.additionalConversion = new AdditionalConversion(to, perc);
    }

    public void convertDamage(Elements to, int perc) {
        if (this.conversion == null) {
            this.conversion = new Conversion();
        }
        this.conversion.add(to, Float.valueOf(perc));
    }

    public void damageTakenAs(Elements to, int perc) {
        if (this.damageTakenAs == null) {
            this.damageTakenAs = new Conversion();
        }
        this.damageTakenAs.add(to, Float.valueOf(perc));
    }

    public StatLayer getLayer() {
        return (StatLayer)ExileDB.StatLayers().get(this.layer);
    }

    public void add(float num) {
        this.number += num;
    }

    public void multiply(float multi) {
        this.number *= multi;
    }

    public void reduce(float num) {
        this.number -= num;
    }

    public float getNumber() {
        StatLayer lay = this.getLayer();
        float num = this.number;
        return num;
    }

    public float getMultiplier() {
        StatLayer lay = this.getLayer();
        float num = this.number;
        float multi = 1.0f + num / 100.0f;
        multi = MathHelper.clamp(multi, lay.min_multi, lay.max_multi);
        return multi;
    }

    public static class Conversion {
        public HashMap<Elements, Float> totals = new HashMap();
        boolean normalized = false;

        public void add(Elements ele, Float n) {
            if (!this.totals.containsKey((Object)ele)) {
                this.totals.put(ele, Float.valueOf(0.0f));
            }
            this.totals.put(ele, Float.valueOf(this.totals.get((Object)ele).floatValue() + n.floatValue()));
        }

        public void normalizeNumbersToCapTo100() {
            this.normalized = true;
            float total = 0.0f;
            for (Float v : this.totals.values()) {
                total += v.floatValue();
            }
            if (total > 100.0f) {
                float multi = 100.0f / total;
                for (Map.Entry<Elements, Float> en : new HashMap<Elements, Float>(this.totals).entrySet()) {
                    this.totals.put(en.getKey(), Float.valueOf(this.totals.get((Object)en.getKey()).floatValue() * multi));
                }
            }
        }
    }

    public static class AdditionalConversion {
        public Elements to;
        public int percent;

        public AdditionalConversion(Elements to, int percent) {
            this.to = to;
            this.percent = percent;
        }
    }
}

