/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.datapacks.base;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.library_of_exile.registry.serialization.ISerializable;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.base.IStatSerializer;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.serializers.StatSerializers;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.test.DatapackStat;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;

public abstract class BaseDatapackStat
extends Stat
implements ISerializable<Stat> {
    public static BaseDatapackStat MAIN_SERIALIZER = new BaseDatapackStat(""){

        @Override
        public String locDescForLangFile() {
            return "";
        }

        @Override
        public String locNameForLangFile() {
            return "";
        }
    };
    public Elements element = Elements.Physical;
    public String id = "";
    protected String serializer;

    public BaseDatapackStat(String serializer) {
        this.serializer = serializer;
    }

    @Override
    public boolean IsPercent() {
        return this.is_perc;
    }

    @Override
    public final Elements getElement() {
        return this.element;
    }

    @Override
    public final boolean isFromDatapack() {
        return true;
    }

    public final String GUID() {
        return this.id;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("ser", this.serializer);
        Preconditions.checkArgument((boolean)StatSerializers.INSTANCE.map.containsKey(this.serializer));
        IStatSerializer<? extends BaseDatapackStat> seri = StatSerializers.INSTANCE.map.get(this.serializer);
        JsonObject serjson = seri.statToJson(this);
        json.add("data", (JsonElement)serjson);
        return json;
    }

    public Stat fromJson(JsonObject json) {
        this.serializer = json.get("ser").getAsString();
        if (this.serializer.equals(DatapackStat.SER)) {
            return (Stat)DatapackStat.SERIALIZER.fromJson(json);
        }
        Preconditions.checkArgument((boolean)StatSerializers.INSTANCE.map.containsKey(this.serializer));
        BaseDatapackStat stat = StatSerializers.INSTANCE.map.get(this.serializer).getStatFromJson(json.get("data").getAsJsonObject());
        return stat;
    }
}

