/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.registry.IWeighted;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.util.UNICODE;
import com.robertx22.library_of_exile.wrappers.ExileText;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.stats.StatGuiGroup;
import com.robertx22.mine_and_slash.database.data.stats.StatScaling;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.base.BaseDatapackStat;
import com.robertx22.mine_and_slash.database.data.stats.effects.base.BaseDamageIncreaseEffect;
import com.robertx22.mine_and_slash.database.data.stats.name_regex.StatNameRegex;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatIconAndNumberButton;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatPanelButton;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.modify.IStatCtxModifier;
import com.robertx22.mine_and_slash.uncommon.STATICS;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;
import com.robertx22.mine_and_slash.uncommon.localization.Formatter;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientTextureUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class Stat
implements IGUID,
IAutoLocName,
IWeighted,
IAutoLocDesc,
JsonExileRegistry<BaseDatapackStat> {
    public static String VAL1 = "[VAL1]";
    static ChatFormatting FORMAT = ChatFormatting.GRAY;
    static ChatFormatting NUMBER = ChatFormatting.GREEN;
    public transient IStatEffect statEffect = null;
    public transient IStatCtxModifier statContextModifier;
    public float min = -1000.0f;
    public float max = STATICS.MAX_FLOAT;
    private float softcap = 0.0f;
    public boolean has_softcap = false;
    public float base = 0.0f;
    public boolean is_perc = false;
    public StatScaling scaling = StatScaling.NONE;
    public boolean is_long = false;
    public String icon = UNICODE.STAR;
    public int order = 100;
    public String format = ChatFormatting.AQUA.m_126666_();
    public StatGroup group = StatGroup.Misc;
    private MultiUseType multiUseType = MultiUseType.MULTIPLY_STAT;
    public boolean minus_is_good = false;
    public boolean show_in_gui = true;
    public StatGuiGroup gui_group = StatGuiGroup.NONE;
    public static ResourceLocation MISSING_ICON = new ResourceLocation("mmorpg", "textures/gui/stat_icons/missing.png");
    public static ResourceLocation DEFAULT_ICON = new ResourceLocation("mmorpg", "textures/gui/stat_icons/default.png");
    transient ResourceLocation cachedIcon = null;
    transient Boolean exists = null;

    public static String format(String str) {
        str = ((String)(str = FORMAT + (String)str)).contains(VAL1 + "%") ? ((String)str).replace(VAL1 + "%", NUMBER + VAL1 + "%" + FORMAT) : ((String)str).replace(VAL1, NUMBER + VAL1 + FORMAT);
        return str;
    }

    public void setSoftCap(float cap) {
        this.has_softcap = true;
        this.softcap = cap;
    }

    public boolean hasSoftCap() {
        return this.has_softcap;
    }

    public final float getHardCap() {
        return this.max;
    }

    public final String getHardCapTooltipText() {
        if (this.max >= STATICS.MAX_FLOAT) {
            return "Inf";
        }
        return "" + (int)this.max;
    }

    public final String getMinCapTooltipText() {
        if (this.min <= -2.1474836E9f) {
            return "Inf";
        }
        return "" + (int)this.min;
    }

    public final float getSoftCap(Unit data) {
        return this.softcap + this.getAdditionalMax(data);
    }

    public final float getCap(Unit data) {
        if (this.hasSoftCap()) {
            return this.softcap + this.getAdditionalMax(data);
        }
        return this.getHardCap();
    }

    public final float getDefaultSoftCap() {
        return this.softcap;
    }

    public float getAdditionalMax(Unit data) {
        return 0.0f;
    }

    public void setUsesMoreMultiplier() {
        this.multiUseType = MultiUseType.MULTIPLICATIVE_DAMAGE;
    }

    public MultiUseType getMultiUseType() {
        if (this.statEffect instanceof BaseDamageIncreaseEffect) {
            this.multiUseType = MultiUseType.MULTIPLICATIVE_DAMAGE;
            return MultiUseType.MULTIPLICATIVE_DAMAGE;
        }
        return this.multiUseType;
    }

    public ChatFormatting getFormat() {
        return ChatFormatting.m_126657_((String)this.format);
    }

    public String getIconNameFormat() {
        return this.getIconNameFormat(this.locNameForLangFile());
    }

    public String getFormatAndIcon() {
        return this.getFormat() + this.icon;
    }

    public String getIconNameFormat(String str) {
        return this.getFormat() + this.icon + " " + str + ChatFormatting.GRAY;
    }

    public MutableComponent getMutableIconNameFormat() {
        return Formatter.ICON_AND_DAMAGE_IN_SPELL_DAMAGE_PROPORTION.locName(this.getFormat() + this.icon, this.locName());
    }

    public boolean isFromDatapack() {
        return false;
    }

    public boolean isRegistryEntryValid() {
        return true;
    }

    public StatNameRegex getStatNameRegex() {
        return StatNameRegex.BASIC;
    }

    public final StatScaling getScaling() {
        return this.scaling;
    }

    public final float scale(ModType mod, float stat, float lvl) {
        if (mod.isFlat()) {
            return this.getScaling().scale(stat, lvl);
        }
        return stat;
    }

    public List<MutableComponent> getCutDescTooltip() {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        List<Component> cut = TooltipUtils.cutIfTooLong(this.locDesc());
        for (int i = 0; i < cut.size(); ++i) {
            MutableComponent comp = ExileText.emptyLine().get();
            if (i == 0) {
                comp.m_130946_(" [");
            }
            comp.m_7220_(cut.get(i));
            if (i == cut.size() - 1) {
                comp.m_130946_("]");
            }
            list.add(comp);
            comp.m_130940_(ChatFormatting.BLUE);
        }
        return list;
    }

    public int Weight() {
        return 1000;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.STAT;
    }

    public ResourceLocation getIconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/stat_icons/" + this.group.id + "/" + this.GUID() + ".png");
    }

    public ResourceLocation getIconForRendering() {
        if (this.cachedIcon == null) {
            ResourceLocation id = this.getIconLocation();
            this.cachedIcon = ClientTextureUtils.textureExists(id) ? id : MISSING_ICON;
        }
        return this.cachedIcon;
    }

    public ResourceLocation getIconForRenderingWithDefault() {
        if (this.exists == null) {
            ResourceLocation id = this.getIconLocation();
            this.exists = ClientTextureUtils.textureExists(id);
        }
        return this.exists != false ? this.getIconForRendering() : DEFAULT_ICON;
    }

    public ResourceLocation getIconForRenderingInGroup() {
        if (this.gui_group.isValid()) {
            return this.getElement().getIconLocation();
        }
        ResourceLocation icon = this.getIconForRendering();
        if (icon.equals((Object)MISSING_ICON)) {
            return DEFAULT_ICON;
        }
        return icon;
    }

    public ChatFormatting getStatGuiTooltipNumberColor(StatData data) {
        return ChatFormatting.YELLOW;
    }

    public int getStatGuiPanelButtonYSize() {
        return this.gui_group.isValid() ? StatPanelButton.ySize + StatIconAndNumberButton.ySize : StatPanelButton.ySize;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locDescGroup() {
        return IBaseAutoLoc.AutoLocGroup.Stats;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.stat." + this.GUID();
    }

    @Override
    public String locDescLangFileGUID() {
        return "mmorpg.stat_desc." + this.GUID();
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Stats;
    }

    public boolean IsPercent() {
        return this.is_perc;
    }

    public abstract Elements getElement();

    public List<MutableComponent> getTooltipList(TooltipStatWithContext info) {
        return info.statinfo.tooltipInfo.statTooltipType.impl.getTooltipList(null, info);
    }

    public StatMod mod(float v1, float v2) {
        return new StatMod(v1, v2, this);
    }

    public static enum StatGroup {
        MAIN("main"),
        WEAPON("weapon"),
        CORE("core"),
        ELEMENTAL("elemental"),
        RESTORATION("restoration"),
        Misc("misc");

        public String id;

        private StatGroup(String id) {
            this.id = id;
        }
    }

    public static enum MultiUseType {
        MULTIPLY_STAT(Words.MULTIPLICATIVE_DAMAGE_MORE, Words.MULTIPLICATIVE_DAMAGE_LESS),
        MULTIPLICATIVE_DAMAGE(Words.MULTIPLICATIVE_DAMAGE_MORE, Words.MULTIPLICATIVE_DAMAGE_LESS);

        public Words prefixWord;
        public Words prefixLessWord;

        private MultiUseType(Words prefixWord, Words prefixLessWord) {
            this.prefixWord = prefixWord;
            this.prefixLessWord = prefixLessWord;
        }
    }
}

