/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.entities;

import com.google.gson.Gson;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.entities.CalculatedSpellData;
import com.robertx22.mine_and_slash.database.data.spells.entities.IDatapackSpellEntity;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.mixin_ducks.FallingBlockAccessor;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashEntities;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class StationaryFallingBlockEntity
extends FallingBlockEntity
implements IDatapackSpellEntity {
    int lifespan = 1000;
    CalculatedSpellData spellData;
    private static final EntityDataAccessor<CompoundTag> SPELL_DATA = SynchedEntityData.m_135353_(StationaryFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<String> ENTITY_NAME = SynchedEntityData.m_135353_(StationaryFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> BLOCK = SynchedEntityData.m_135353_(StationaryFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> IS_FALLING = SynchedEntityData.m_135353_(StationaryFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> FALL_SPEED = SynchedEntityData.m_135353_(StationaryFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    boolean removeNextTick = false;
    boolean exploded = false;
    static Gson GSON = new Gson();

    public StationaryFallingBlockEntity(EntityType<? extends FallingBlockEntity> entityType, Level world) {
        super((EntityType)SlashEntities.SIMPLE_BLOCK_ENTITY.get(), world);
    }

    public StationaryFallingBlockEntity(Level world, BlockPos pos, BlockState block) {
        this((EntityType<? extends FallingBlockEntity>)((EntityType)SlashEntities.SIMPLE_BLOCK_ENTITY.get()), world);
        FallingBlockAccessor acc = (FallingBlockAccessor)((Object)this);
        acc.setBlockState(block);
        acc.setDestroyedOnLanding(false);
        this.f_19850_ = true;
        this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + (double)((1.0f - this.m_20206_()) / 2.0f), (double)pos.m_123343_() + 0.5);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = pos.m_123341_();
        this.f_19855_ = pos.m_123342_();
        this.f_19856_ = pos.m_123343_();
        this.m_31959_(this.m_20183_());
    }

    public BlockState m_31980_() {
        try {
            return ((Block)VanillaUTIL.REGISTRY.blocks().get(new ResourceLocation((String)this.f_19804_.m_135370_(BLOCK)))).m_49966_();
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.m_31980_();
        }
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    public void scheduleRemoval() {
        this.removeNextTick = true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        if (this.removeNextTick) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        if (((Boolean)this.f_19804_.m_135370_(IS_FALLING)).booleanValue()) {
            if (!this.m_20068_()) {
                float speed = ((Float)this.f_19804_.m_135370_(FALL_SPEED)).floatValue();
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(speed *= 1.0f + 0.03f * (float)this.f_19797_), 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.m_20096_()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        try {
            LivingEntity caster;
            if (!this.m_9236_().f_46443_ && this.getSpellData() != null && (caster = this.getSpellData().getCaster(this.m_9236_())) != null) {
                this.getSpellData().getSpell().getAttached().tryActivate(this.m_6302_(), SpellCtx.onTick(caster, (Entity)this, this.getSpellData()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.f_19797_ > this.lifespan) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        try {
            if (!this.exploded) {
                LivingEntity caster;
                this.exploded = true;
                if (this.getSpellData() != null && (caster = this.getSpellData().getCaster(this.m_9236_())) != null) {
                    this.getSpellData().getSpell().getAttached().tryActivate(this.m_6302_(), SpellCtx.onExpire(caster, (Entity)this, this.getSpellData()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.m_142687_(pReason);
    }

    public CalculatedSpellData getSpellData() {
        CompoundTag nbt;
        if (this.m_9236_().f_46443_ && this.spellData == null && (nbt = (CompoundTag)this.f_19804_.m_135370_(SPELL_DATA)) != null) {
            this.spellData = (CalculatedSpellData)GSON.fromJson(nbt.m_128461_("spell"), CalculatedSpellData.class);
        }
        return this.spellData;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPELL_DATA, (Object)new CompoundTag());
        this.f_19804_.m_135372_(ENTITY_NAME, (Object)"");
        this.f_19804_.m_135372_(BLOCK, (Object)"");
        this.f_19804_.m_135372_(IS_FALLING, (Object)false);
        this.f_19804_.m_135372_(FALL_SPEED, (Object)Float.valueOf(-0.04f));
        super.m_8097_();
    }

    public String m_6302_() {
        return (String)this.f_19804_.m_135370_(ENTITY_NAME);
    }

    @Override
    public void init(LivingEntity caster, CalculatedSpellData data, MapHolder holder) {
        this.spellData = data;
        this.lifespan = holder.get(MapField.LIFESPAN_TICKS).intValue();
        this.lifespan = (int)((float)this.lifespan * data.data.getNumber((String)EventData.DURATION_MULTI, (float)1.0f).number);
        data.data.setString(EventData.ITEM_ID, holder.get(MapField.ITEM));
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("spell", GSON.toJson((Object)this.spellData));
        this.f_19804_.m_135381_(SPELL_DATA, (Object)nbt);
        this.f_19804_.m_135381_(ENTITY_NAME, (Object)holder.get(MapField.ENTITY_NAME));
        this.f_19804_.m_135381_(BLOCK, (Object)holder.get(MapField.BLOCK));
        this.f_19804_.m_135381_(FALL_SPEED, (Object)Float.valueOf(holder.getOrDefault(MapField.BLOCK_FALL_SPEED, -0.04).floatValue()));
    }
}

