/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.entities;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.library_of_exile.utils.geometry.MyPosition;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.ProjectileCastHelper;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.AoeSelector;
import com.robertx22.mine_and_slash.database.data.spells.entities.CalculatedSpellData;
import com.robertx22.mine_and_slash.database.data.spells.entities.IDatapackProjectileEntity;
import com.robertx22.mine_and_slash.database.data.spells.entities.renders.IMyRenderAsItem;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SimpleProjectileEntity
extends AbstractArrow
implements IMyRenderAsItem,
IDatapackProjectileEntity {
    CalculatedSpellData spellData;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    protected boolean inGround;
    private int ticksInGround = 0;
    public boolean moveTowardsEnemies = false;
    private static final EntityDataAccessor<CompoundTag> SPELL_DATA = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<String> ENTITY_NAME = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> EXPIRE_ON_ENTITY_HIT = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HIT_ALLIES = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PIERCE = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DEATH_TIME = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CHAINS = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> EXPIRE_ON_BLOCK_HIT = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> ACCELERATION = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> YAW_VELOCITY = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> YAW_ACCELERATION = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Vector3f> FORWARD_VECTOR = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Vector3f> UP_VECTOR = SynchedEntityData.m_135353_(SimpleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public Entity ignoreEntity;
    boolean collidedAlready = false;
    private boolean motionDirty = false;
    private Float cachedSpeedMultiplier = null;
    private Float cachedYawSpeedMultiplier = null;
    boolean exploded = false;
    Entity target = null;
    boolean removeNextTick = false;
    static Gson GSON = new Gson();
    LivingEntity caster;
    MapHolder holder;
    float speed = 0.0f;

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected boolean onExpireProc(LivingEntity caster) {
        return true;
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float m_6143_() {
        return 1.0f;
    }

    public int getTicksInGround() {
        return this.ticksInGround;
    }

    public int getDeathTime() {
        return (Integer)this.f_19804_.m_135370_(DEATH_TIME);
    }

    public void setDeathTime(int newVal) {
        this.f_19804_.m_135381_(DEATH_TIME, (Object)newVal);
    }

    public float getSpeedMultiplier() {
        if (this.cachedSpeedMultiplier == null) {
            this.cachedSpeedMultiplier = Float.valueOf(this.getSpellData().data.getNumber((String)EventData.PROJECTILE_SPEED_MULTI, (float)1.0f).number);
        }
        return this.cachedSpeedMultiplier.floatValue();
    }

    public float getYawSpeedMultiplier() {
        if (this.cachedYawSpeedMultiplier == null) {
            this.cachedYawSpeedMultiplier = Float.valueOf(this.getSpellData().data.getNumber((String)EventData.PROJECTILE_YAW_SPEED_MULTI, (float)1.0f).number);
        }
        return this.cachedYawSpeedMultiplier.floatValue();
    }

    public SimpleProjectileEntity(EntityType<? extends Entity> type, Level worldIn) {
        super(type, worldIn);
        this.m_36740_(SoundEvents.f_271165_);
    }

    protected void moveToImpactPosition(HitResult result) {
        if (result instanceof EntityHitResult) {
            EntityHitResult enres = (EntityHitResult)result;
            AABB aabb = enres.m_82443_().m_20191_().m_82400_(0.3);
            Vec3 traceEnd = this.m_20182_().m_82549_(this.m_20184_());
            Optional clipped = aabb.m_82371_(this.m_20182_(), traceEnd);
            if (clipped.isPresent()) {
                this.m_146884_((Vec3)clipped.get());
            }
        } else {
            this.m_146884_(result.m_82450_());
        }
    }

    public Entity getEntityHit(HitResult result, double radius) {
        List<LivingEntity> entities;
        EntityHitResult enres = null;
        if (result instanceof EntityHitResult) {
            enres = (EntityHitResult)result;
        }
        if (enres == null) {
            return null;
        }
        if (enres.m_82443_() instanceof Entity && enres.m_82443_() != this.getCaster()) {
            return enres.m_82443_();
        }
        if (this.getCaster() != null && (entities = EntityFinder.start((Entity)this.getCaster(), LivingEntity.class, this.m_20182_()).radius(radius).build()).size() > 0) {
            LivingEntity closest = entities.get(0);
            for (LivingEntity en : entities) {
                if (en == closest || !(this.m_20270_((Entity)en) < this.m_20270_((Entity)closest))) continue;
                closest = en;
            }
            return closest;
        }
        return null;
    }

    public void onTick() {
        this.applyAcceleration();
        this.applyYawVelocity();
        if (this.getCaster() != null) {
            this.tryMoveTowardsTargets();
            if (!this.m_9236_().f_46443_) {
                this.getSpellData().getSpell().getAttached().tryActivate(this.m_6302_(), SpellCtx.onTick(this.getCaster(), (Entity)this, this.getSpellData()));
            }
        }
    }

    public void m_142687_(Entity.RemovalReason r) {
        if (!this.exploded) {
            this.exploded = true;
            LivingEntity caster = this.getCaster();
            if (caster != null && !this.m_9236_().f_46443_) {
                this.getSpellData().getSpell().getAttached().tryActivate(this.m_6302_(), SpellCtx.onExpire(caster, (Entity)this, this.getSpellData()));
            }
        }
        super.m_142687_(r);
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public final void m_8119_() {
        if (this.removeNextTick) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        try {
            super.m_8119_();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.scheduleRemoval();
        }
        if (this.getSpellData() == null || this.getCaster() == null) {
            if (this.f_19797_ > 100) {
                this.scheduleRemoval();
            }
            return;
        }
        if (this.motionDirty) {
            this.syncMotion();
        }
        try {
            this.onTick();
            if (this.inGround) {
                ++this.ticksInGround;
            }
            if (this.f_19797_ >= this.getDeathTime()) {
                this.onExpireProc(this.getCaster());
                this.scheduleRemoval();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.scheduleRemoval();
        }
    }

    private void syncMotion() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityMotionPacket((Entity)this));
        }
    }

    protected void setMotionDirty() {
        this.motionDirty = true;
    }

    private void setSpeed(double newSpeed) {
        Vec3 velocity = this.m_20184_();
        double speed = velocity.m_82553_();
        if (speed >= 1.0E-4) {
            double factor = newSpeed / speed;
            this.m_20256_(velocity.m_82490_(factor));
        } else if (newSpeed != 0.0) {
            Vector3f forward = (Vector3f)this.f_19804_.m_135370_(FORWARD_VECTOR);
            this.m_20256_(new Vec3(forward.mul((float)newSpeed)));
        }
    }

    private void applyAcceleration() {
        float acceleration = ((Float)this.f_19804_.m_135370_(ACCELERATION)).floatValue();
        if (acceleration == 0.0f) {
            return;
        }
        Vec3 velocity = this.m_20184_();
        double speed = velocity.m_82553_();
        this.setSpeed(Math.max(speed + (double)acceleration, 0.0));
    }

    private void setPitch(float pitch) {
        float pitchRad = pitch * ((float)Math.PI / 180);
        float cosPitch = Mth.m_14089_((float)pitchRad);
        float sinPitch = Mth.m_14031_((float)pitchRad);
        Vector3f velocity = this.m_20184_().m_252839_();
        float speed = velocity.length();
        float speedXY = (float)Math.sqrt(Math.fma(velocity.x, velocity.x, velocity.z * velocity.z));
        if (speedXY < 1.0E-4f) {
            velocity = (Vector3f)this.f_19804_.m_135370_(FORWARD_VECTOR);
            speedXY = (float)Math.sqrt(Math.fma(velocity.x, velocity.x, velocity.z * velocity.z));
            if (speedXY < 1.0E-4f) {
                if (velocity.y > 0.0f) {
                    velocity = (Vector3f)this.f_19804_.m_135370_(UP_VECTOR);
                    velocity.x *= -1.0f;
                    velocity.z *= -1.0f;
                } else {
                    velocity = (Vector3f)this.f_19804_.m_135370_(UP_VECTOR);
                }
                speedXY = (float)Math.sqrt(Math.fma(velocity.x, velocity.x, velocity.z * velocity.z));
            }
        }
        float scale = cosPitch / speedXY;
        velocity.x *= scale;
        velocity.z *= scale;
        velocity.y = -sinPitch;
        velocity.mul(speed);
        this.m_20334_(velocity.x, velocity.y, velocity.z);
    }

    private void adjustPitch(float angle) {
        Vector3f velocity = this.m_20184_().m_252839_();
        Vector3f axis = velocity.cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).normalize();
        velocity.rotateAxis(angle * ((float)Math.PI / 180), axis.x, axis.y, axis.z);
        this.m_20334_(velocity.x, velocity.y, velocity.z);
    }

    private void adjustYaw(float angle) {
        Vector3f velocity = this.m_20184_().m_252839_();
        Vector3f axis = (Vector3f)this.f_19804_.m_135370_(UP_VECTOR);
        velocity.rotateAxis(-angle * ((float)Math.PI / 180), axis.x, axis.y, axis.z);
        this.m_20334_(velocity.x, velocity.y, velocity.z);
    }

    private void applyYawVelocity() {
        float yawVelocity = ((Float)this.f_19804_.m_135370_(YAW_VELOCITY)).floatValue();
        float yawAcceleration = ((Float)this.f_19804_.m_135370_(YAW_ACCELERATION)).floatValue();
        if (yawVelocity == 0.0f && yawAcceleration == 0.0f) {
            return;
        }
        this.f_19804_.m_135381_(YAW_VELOCITY, (Object)Float.valueOf(yawVelocity += yawAcceleration));
        this.adjustYaw(yawVelocity);
    }

    public void tryMoveTowardsTargets() {
        if (this.moveTowardsEnemies) {
            if (this.target == null || !this.target.m_6084_() || this.f_19797_ % 20 == 0) {
                int radius = this.getSpellData().getSpell().config.tracking_radius;
                EntityFinder.Setup<LivingEntity> b = EntityFinder.start((Entity)this.getCaster(), LivingEntity.class, this.m_20182_()).finder(EntityFinder.SelectionType.RADIUS).searchFor(this.getSpellData().getSpell().config.tracks).predicate(x -> AoeSelector.canHit(this.m_20182_(), (Entity)x)).radius(radius);
                this.target = b.getClosest();
            }
            if (this.target != null) {
                double speed = this.m_20184_().m_82553_();
                Vec3 direction = ProjectileCastHelper.positionToVelocity(new MyPosition(this.m_20182_()), new MyPosition(this.target.m_146892_()));
                this.m_20256_(direction.m_82490_(speed));
                this.setMotionDirty();
            }
        }
    }

    protected EntityHitResult m_6351_(Vec3 pos, Vec3 posPlusMotion) {
        EntityHitResult res = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)pos, (Vec3)posPlusMotion, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), e -> !e.m_5833_() && e.m_6087_() && e instanceof Entity && e != this.getCaster() && e != this.ignoreEntity);
        if (!((Boolean)this.f_19804_.m_135370_(HIT_ALLIES)).booleanValue() && res != null && this.getCaster() != null && res.m_82443_() instanceof LivingEntity && AllyOrEnemy.allies.is((Entity)this.getCaster(), (LivingEntity)res.m_82443_())) {
            return null;
        }
        return res;
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        HitResult.Type raytraceresult$type = raytraceResultIn.m_6662_();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.onImpact(raytraceResultIn);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            if (this.collidedAlready) {
                return;
            }
            this.onImpact(raytraceResultIn);
            this.collidedAlready = true;
            this.inGround = true;
        }
    }

    protected void onImpact(HitResult result) {
        int chains;
        this.moveToImpactPosition(result);
        Entity entityHit = this.getEntityHit(result, 0.3);
        if (entityHit != null) {
            if (this.m_9236_().f_46443_) {
                SoundUtils.playSound((Entity)this, (SoundEvent)SoundEvents.f_11915_, (float)1.0f, (float)0.9f);
            }
            LivingEntity caster = this.getCaster();
            LivingEntity en = null;
            if (!(entityHit instanceof LivingEntity)) {
                EnderDragonPart part;
                if (entityHit instanceof EnderDragonPart && !(part = (EnderDragonPart)entityHit).m_6673_(this.m_269291_().m_269333_(caster))) {
                    en = part.f_31010_;
                }
            } else if (entityHit instanceof LivingEntity) {
                en = (LivingEntity)entityHit;
            }
            if (en == null) {
                return;
            }
            if (caster != null && !Load.Unit((Entity)caster).alreadyHit((Entity)this, en) && !this.m_9236_().f_46443_) {
                SpellCtx ctx = SpellCtx.onHit(caster, (Entity)this, en, this.getSpellData());
                this.getSpellData().getSpell().getAttached().tryActivate(this.m_6302_(), ctx);
            }
        } else if (this.m_9236_().f_46443_) {
            SoundUtils.playSound((Entity)this, (SoundEvent)SoundEvents.f_12446_, (float)0.7f, (float)0.9f);
        }
        if (entityHit != null) {
            if (!((Boolean)this.f_19804_.m_135370_(EXPIRE_ON_ENTITY_HIT)).booleanValue()) {
                return;
            }
            this.scheduleRemoval();
        }
        if (result instanceof BlockHitResult && ((Boolean)this.f_19804_.m_135370_(EXPIRE_ON_BLOCK_HIT)).booleanValue()) {
            this.scheduleRemoval();
        }
        if (!this.m_9236_().f_46443_ && this.getCaster() != null && (chains = ((Integer)this.f_19804_.m_135370_(CHAINS)).intValue()) > 0) {
            LivingEntity target;
            --chains;
            if (entityHit == null) {
                chains = 0;
            }
            float radius = this.getSpellData().data.getNumber((String)EventData.AREA_MULTI, (float)1.0f).number;
            EntityFinder.Setup<LivingEntity> b = EntityFinder.start((Entity)this.getCaster(), LivingEntity.class, this.m_20182_()).finder(EntityFinder.SelectionType.RADIUS).searchFor(AllyOrEnemy.enemies).radius(5.0f * radius);
            if (entityHit instanceof LivingEntity) {
                LivingEntity hit = (LivingEntity)entityHit;
                b.excludeEntity(hit);
            }
            if ((target = b.getClosest()) != null) {
                SimpleProjectileEntity en = (SimpleProjectileEntity)this.m_6095_().m_20615_(this.m_9236_());
                en.m_146884_(this.m_20182_());
                CalculatedSpellData sd = this.getSpellDataCopy();
                ++sd.chains_did;
                en.init(this.caster, sd, this.holder);
                en.f_19804_.m_135381_(CHAINS, (Object)chains);
                Vec3 vel = ProjectileCastHelper.positionToVelocity(new MyPosition(this.m_20182_()), new MyPosition(target.m_146892_()));
                en.m_20256_(vel.m_82541_().m_82542_((double)this.speed, (double)this.speed, (double)this.speed));
                this.m_9236_().m_7967_((Entity)en);
            }
        }
    }

    public void scheduleRemoval() {
        if (!this.m_213877_()) {
            this.m_146870_();
            this.removeNextTick = true;
        }
    }

    public void m_7380_(CompoundTag nbt) {
        try {
            nbt.m_128405_("xTile", this.xTile);
            nbt.m_128405_("yTile", this.yTile);
            nbt.m_128405_("zTile", this.zTile);
            nbt.m_128344_("inGround", (byte)(this.inGround ? 1 : 0));
            nbt.m_128405_("deathTime", this.getDeathTime());
            nbt.m_128359_("data", GSON.toJson((Object)this.spellData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_7378_(CompoundTag nbt) {
        try {
            this.xTile = nbt.m_128451_("xTile");
            this.yTile = nbt.m_128451_("yTile");
            this.zTile = nbt.m_128451_("zTile");
            this.inGround = nbt.m_128445_("inGround") == 1;
            this.setDeathTime(nbt.m_128451_("deathTime"));
            this.spellData = (CalculatedSpellData)GSON.fromJson(nbt.m_128461_("data"), CalculatedSpellData.class);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    public LivingEntity getCaster() {
        if (this.caster == null) {
            try {
                this.caster = Utilities.getLivingEntityByUUID(this.m_9236_(), UUID.fromString(this.getSpellData().caster_uuid));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.caster;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPELL_DATA, (Object)new CompoundTag());
        this.f_19804_.m_135372_(ENTITY_NAME, (Object)"");
        this.f_19804_.m_135372_(EXPIRE_ON_ENTITY_HIT, (Object)true);
        this.f_19804_.m_135372_(EXPIRE_ON_BLOCK_HIT, (Object)true);
        this.f_19804_.m_135372_(HIT_ALLIES, (Object)false);
        this.f_19804_.m_135372_(PIERCE, (Object)false);
        this.f_19804_.m_135372_(DEATH_TIME, (Object)100);
        this.f_19804_.m_135372_(CHAINS, (Object)0);
        this.f_19804_.m_135372_(ACCELERATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(YAW_VELOCITY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(YAW_ACCELERATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FORWARD_VECTOR, (Object)new Vector3f());
        this.f_19804_.m_135372_(UP_VECTOR, (Object)new Vector3f());
        super.m_8097_();
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public CalculatedSpellData getSpellData() {
        try {
            CompoundTag nbt;
            if (this.m_9236_().f_46443_ && this.spellData == null && (nbt = (CompoundTag)this.f_19804_.m_135370_(SPELL_DATA)) != null) {
                this.spellData = (CalculatedSpellData)GSON.fromJson(nbt.m_128461_("spell"), CalculatedSpellData.class);
            }
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        return this.spellData;
    }

    public CalculatedSpellData getSpellDataCopy() {
        return (CalculatedSpellData)GSON.fromJson(GSON.toJson((Object)this.getSpellData()), CalculatedSpellData.class);
    }

    @Override
    public ItemStack getItem() {
        try {
            Item item = (Item)VanillaUTIL.REGISTRY.items().get(new ResourceLocation(this.getSpellData().data.getString(EventData.ITEM_ID)));
            if (item != null) {
                return new ItemStack((ItemLike)item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ItemStack((ItemLike)Items.f_41852_);
    }

    public String m_6302_() {
        return (String)this.f_19804_.m_135370_(ENTITY_NAME);
    }

    public void m_6123_(Player player) {
    }

    @Override
    public void init(LivingEntity caster, CalculatedSpellData data, MapHolder holder) {
        this.holder = holder;
        this.spellData = data;
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        this.m_20242_(holder.getOrDefault(MapField.GRAVITY, true) == false);
        this.setDeathTime(holder.get(MapField.LIFESPAN_TICKS).intValue());
        this.f_19804_.m_135381_(EXPIRE_ON_ENTITY_HIT, (Object)holder.getOrDefault(MapField.EXPIRE_ON_ENTITY_HIT, true));
        this.f_19804_.m_135381_(EXPIRE_ON_BLOCK_HIT, (Object)holder.getOrDefault(MapField.EXPIRE_ON_BLOCK_HIT, true));
        this.f_19804_.m_135381_(HIT_ALLIES, (Object)holder.getOrDefault(MapField.HITS_ALLIES, false));
        this.f_19804_.m_135381_(CHAINS, (Object)(holder.getOrDefault(MapField.CHAIN_COUNT, 0.0).intValue() + (int)data.data.getNumber((String)EventData.BONUS_CHAINS).number));
        this.m_20101_();
        if (data.data.getBoolean(EventData.PIERCE)) {
            this.f_19804_.m_135381_(EXPIRE_ON_ENTITY_HIT, (Object)false);
        }
        this.moveTowardsEnemies = holder.getOrDefault(MapField.TRACKS_ENEMIES, false);
        this.speed = holder.getOrDefault(MapField.PROJECTILE_SPEED, 1.0).floatValue();
        this.f_19804_.m_135381_(ACCELERATION, (Object)Float.valueOf(holder.getOrDefault(MapField.PROJECTILE_ACCELERATION, 0.0).floatValue() * this.getSpeedMultiplier()));
        this.f_19804_.m_135381_(YAW_VELOCITY, (Object)Float.valueOf(holder.getOrDefault(MapField.YAW_VELOCITY, 0.0).floatValue() * this.getYawSpeedMultiplier()));
        this.f_19804_.m_135381_(YAW_ACCELERATION, (Object)Float.valueOf(holder.getOrDefault(MapField.YAW_ACCELERATION, 0.0).floatValue() * this.getYawSpeedMultiplier()));
        data.data.setString(EventData.ITEM_ID, holder.get(MapField.ITEM));
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("spell", GSON.toJson((Object)this.spellData));
        this.f_19804_.m_135381_(SPELL_DATA, (Object)nbt);
        this.m_5602_((Entity)caster);
        String name = holder.get(MapField.ENTITY_NAME);
        this.f_19804_.m_135381_(ENTITY_NAME, (Object)name);
    }

    @Override
    public void setVectors(Vector3f forward, Vector3f up) {
        this.f_19804_.m_135381_(FORWARD_VECTOR, (Object)forward);
        this.f_19804_.m_135381_(UP_VECTOR, (Object)up);
    }

    @Override
    public void handleModifyProjectileAction(MapHolder data) {
        if (data.has(MapField.PROJECTILE_SPEED)) {
            this.setSpeed(data.get(MapField.PROJECTILE_SPEED) * (double)this.getSpeedMultiplier());
            this.setMotionDirty();
        }
        if (data.has(MapField.PROJECTILE_ACCELERATION)) {
            this.f_19804_.m_135381_(ACCELERATION, (Object)Float.valueOf(data.get(MapField.PROJECTILE_ACCELERATION).floatValue() * this.getSpeedMultiplier()));
        }
        if (data.has(MapField.PITCH)) {
            this.setPitch(data.get(MapField.PITCH).floatValue());
            this.setMotionDirty();
        }
        if (data.has(MapField.PITCH_OFFSET)) {
            this.adjustPitch(data.get(MapField.PITCH_OFFSET).floatValue());
            this.setMotionDirty();
        }
        if (data.has(MapField.YAW_OFFSET)) {
            this.adjustYaw(data.get(MapField.YAW_OFFSET).floatValue());
            this.setMotionDirty();
        }
        if (data.has(MapField.YAW_VELOCITY)) {
            this.f_19804_.m_135381_(YAW_VELOCITY, (Object)Float.valueOf(data.get(MapField.YAW_VELOCITY).floatValue() * this.getYawSpeedMultiplier()));
        }
        if (data.has(MapField.YAW_ACCELERATION)) {
            this.f_19804_.m_135381_(YAW_ACCELERATION, (Object)Float.valueOf(data.get(MapField.YAW_ACCELERATION).floatValue() * this.getYawSpeedMultiplier()));
        }
    }
}

