/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.selectors;

import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.AoeSelector;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.BaseTargetSelector;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class InFrontSelector
extends BaseTargetSelector {
    public InFrontSelector() {
        super(Arrays.asList(MapField.DISTANCE, MapField.WIDTH, MapField.ENTITY_PREDICATE));
    }

    @Override
    public List<LivingEntity> get(SpellCtx ctx, LivingEntity caster, LivingEntity target, Vec3 pos, MapHolder data) {
        AllyOrEnemy predicate = data.getEntityPredicate();
        float distance = data.get(MapField.DISTANCE).floatValue();
        float width = data.get(MapField.WIDTH).floatValue();
        EntityFinder.Setup<LivingEntity> finder = EntityFinder.start((Entity)caster, LivingEntity.class, pos).finder(EntityFinder.SelectionType.IN_FRONT).searchFor(predicate).radius(Math.min(width, distance)).distance(distance);
        return finder.build().stream().filter(x -> AoeSelector.canHit(ctx.getPos(), (Entity)x)).collect(Collectors.toList());
    }

    public MapHolder create(Double distance, Double width, AllyOrEnemy pred) {
        MapHolder d = new MapHolder();
        d.type = this.GUID();
        d.put(MapField.DISTANCE, distance);
        d.put(MapField.WIDTH, width);
        d.put(MapField.ENTITY_PREDICATE, pred.name());
        this.validate(d);
        return d;
    }

    public String GUID() {
        return "in_front";
    }
}

