/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.packets;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.library_of_exile.registry.serialization.MyGSON;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.library_of_exile.utils.geometry.Circle3d;
import com.robertx22.library_of_exile.utils.geometry.MyPosition;
import com.robertx22.library_of_exile.utils.geometry.ShapeHelper;
import com.robertx22.library_of_exile.utils.geometry.XTimesData;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity.ParticleMotion;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity.ParticleShape;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ParticlesPacket
extends MyPacket<ParticlesPacket> {
    public Data data = new Data();

    public ParticlesPacket(Data data) {
        this.data = data;
    }

    public ResourceLocation getIdentifier() {
        return SlashRef.id("particles");
    }

    public void loadFromData(FriendlyByteBuf buf) {
        this.data = (Data)MyGSON.GSON.fromJson(buf.m_130277_(), Data.class);
    }

    public void saveToData(FriendlyByteBuf buf) {
        buf.m_130070_(MyGSON.GSON.toJson((Object)this.data));
    }

    public void onReceived(ExilePacketContext ctx) {
        if ((double)this.data.amount > (Double)ClientConfigs.getConfig().DONT_CULL_PARTICLES_UNDER.get()) {
            this.data.amount = (int)((double)this.data.amount * (Double)ClientConfigs.getConfig().SPELL_PARTICLE_MULTI.get());
        }
        Player p = ctx.getPlayer();
        Level world = p.m_9236_();
        SimpleParticleType particle = this.data.getParticle();
        MyPosition middle = new MyPosition(this.data.pos);
        Vec3 vel = this.data.vel;
        Circle3d c = new Circle3d(new MyPosition(this.data.pos), this.data.radius);
        c.doXTimes(this.data.amount, arg_0 -> this.lambda$onReceived$0(middle, vel, (ShapeHelper)c, world, particle, arg_0));
    }

    public MyPacket<ParticlesPacket> newInstance() {
        return new ParticlesPacket(new Data());
    }

    private /* synthetic */ void lambda$onReceived$0(MyPosition middle, Vec3 vel, ShapeHelper c, Level world, SimpleParticleType particle, XTimesData x) {
        MyPosition sp = this.data.shape.getPosition(middle, this.data.radius, x.multi);
        float yRandom = (int)RandomUtils.RandomRange((float)0.0f, (float)this.data.yrand);
        sp = new MyPosition(sp.f_82479_ - vel.f_82479_ / 2.0, sp.f_82480_ - vel.f_82480_ / 2.0 + (double)this.data.height, sp.f_82481_ - vel.f_82481_ / 2.0);
        Vec3 v = this.data.motion.getMotion(new Vec3(sp.f_82479_, sp.f_82480_ + (double)yRandom, sp.f_82481_), this.data.casterAngle, this.data.pos).m_82542_((double)this.data.motionMulti, (double)this.data.motionMulti, (double)this.data.motionMulti);
        c.spawnParticle(world, sp.asVector3D(), (ParticleOptions)particle, new MyPosition(v).asVector3D());
    }

    public static class Data {
        public Vec3 pos = new Vec3(0.0, 0.0, 0.0);
        public Vec3 vel = new Vec3(0.0, 0.0, 0.0);
        public Vec3 casterAngle = new Vec3(0.0, 0.0, 0.0);
        public float height = 0.0f;
        public float yrand = 0.0f;
        public float radius = 1.0f;
        public String particle = "";
        public ParticleMotion motion = ParticleMotion.None;
        public ParticleShape shape = ParticleShape.CIRCLE;
        public int amount = 1;
        public float motionMulti = 1.0f;

        public SimpleParticleType getParticle() {
            return (SimpleParticleType)BuiltInRegistries.f_257034_.m_7745_(new ResourceLocation(this.particle));
        }
    }
}

