/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.conditions;

import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.EffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.Arrays;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EntityInRadiusCondition
extends EffectCondition {
    public EntityInRadiusCondition() {
        super(Arrays.asList(MapField.RADIUS, MapField.SELECTION_TYPE, MapField.ENTITY_PREDICATE));
    }

    @Override
    public boolean canActivate(SpellCtx ctx, MapHolder data) {
        AllyOrEnemy predicate = data.getEntityPredicate();
        Double radius = data.get(MapField.RADIUS);
        radius = radius * (double)ctx.calculatedSpellData.data.getNumber((String)EventData.AREA_MULTI, (float)1.0f).number;
        EntityFinder.Setup<LivingEntity> finder = EntityFinder.start((Entity)ctx.caster, LivingEntity.class, ctx.getBlockPos()).finder(EntityFinder.SelectionType.RADIUS).searchFor(predicate).height(data.getOrDefault(MapField.HEIGHT, radius)).radius(radius);
        return !finder.build().isEmpty();
    }

    public MapHolder enemiesInRadius(Double radius) {
        return this.create(radius, EntityFinder.SelectionType.RADIUS, AllyOrEnemy.enemies);
    }

    public MapHolder alliesInRadius(Double radius) {
        return this.create(radius, EntityFinder.SelectionType.RADIUS, AllyOrEnemy.allies);
    }

    public MapHolder create(Double radius, EntityFinder.SelectionType type, AllyOrEnemy pred) {
        MapHolder d = new MapHolder();
        d.type = this.GUID();
        d.put(MapField.RADIUS, radius);
        d.put(MapField.SELECTION_TYPE, type.name());
        d.put(MapField.ENTITY_PREDICATE, pred.name());
        this.validate(d);
        return d;
    }

    public String GUID() {
        return "is_en_in_radius";
    }
}

