/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.conditions;

import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.mine_and_slash.database.data.spells.components.BaseFieldNeeder;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.CasterHasEffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.CasterHasMnsEffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.CasterHasStatCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.ChanceCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.EntityInRadiusCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.HasMnsEffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.IsAllyCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.IsCasterCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.IsNotOnCooldownCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.OnAttackedCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.OnCastCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.OnExpireCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.OnHitCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.OnTickCondition;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.TargetHasEffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import java.util.HashMap;
import java.util.List;

public abstract class EffectCondition
extends BaseFieldNeeder
implements IGUID {
    public static IsNotOnCooldownCondition IS_NOT_ON_COOLDOWN;
    public static EntityInRadiusCondition IS_ENTITY_IN_RADIUS;
    public static IsCasterCondition IS_TARGET_CASTER;
    public static OnTickCondition EVERY_X_TICKS;
    public static ChanceCondition CHANCE;
    public static CasterHasEffectCondition CASTER_HAS_POTION;
    public static OnCastCondition ON_CAST;
    public static OnExpireCondition ON_ENTITY_EXPIRE;
    public static OnHitCondition ON_HIT;
    public static CasterHasStatCondition CASTER_HAS_STAT;
    public static IsAllyCondition IS_TARGET_ALLY;
    public static TargetHasEffectCondition TARGET_HAS_POTION;
    public static OnAttackedCondition ON_ATTACKED;
    public static HasMnsEffectCondition HAS_MNS_EFFECT;
    public static CasterHasMnsEffectCondition CASTER_HAS_MNS_EFFECT;
    public static HashMap<String, EffectCondition> MAP;

    public EffectCondition(List<MapField> requiredPieces) {
        super(requiredPieces);
    }

    public abstract boolean canActivate(SpellCtx var1, MapHolder var2);

    public final boolean can(SpellCtx ctx, MapHolder data) {
        boolean can = this.canActivate(ctx, data);
        boolean not = data.getOrDefault(MapField.IS_FALSE, false);
        if (not) {
            return !can;
        }
        return can;
    }

    public static final boolean conditionsPass(List<MapHolder> ifs, SpellCtx ctx) {
        boolean did = true;
        boolean didOne = false;
        for (MapHolder part : ifs) {
            EffectCondition condition = MAP.get(part.type);
            boolean passed = condition.can(ctx, part);
            boolean isOptional = part.getOrDefault(MapField.OPTIONAL, false);
            if (passed) {
                didOne = true;
                continue;
            }
            if (isOptional) continue;
            return false;
        }
        if (didOne) {
            did = true;
        }
        return did;
    }

    private static <T extends EffectCondition> T of(T s) {
        MAP.put(s.GUID(), s);
        return s;
    }

    public static void init() {
        HAS_MNS_EFFECT = EffectCondition.of(new HasMnsEffectCondition());
        CASTER_HAS_MNS_EFFECT = EffectCondition.of(new CasterHasMnsEffectCondition());
        IS_TARGET_CASTER = EffectCondition.of(new IsCasterCondition());
        IS_NOT_ON_COOLDOWN = EffectCondition.of(new IsNotOnCooldownCondition());
        IS_ENTITY_IN_RADIUS = EffectCondition.of(new EntityInRadiusCondition());
        TARGET_HAS_POTION = EffectCondition.of(new TargetHasEffectCondition());
        IS_TARGET_ALLY = EffectCondition.of(new IsAllyCondition());
        EVERY_X_TICKS = EffectCondition.of(new OnTickCondition());
        CHANCE = EffectCondition.of(new ChanceCondition());
        CASTER_HAS_POTION = EffectCondition.of(new CasterHasEffectCondition());
        ON_CAST = EffectCondition.of(new OnCastCondition());
        ON_ENTITY_EXPIRE = EffectCondition.of(new OnExpireCondition());
        ON_HIT = EffectCondition.of(new OnHitCondition());
        CASTER_HAS_STAT = EffectCondition.of(new CasterHasStatCondition());
        ON_ATTACKED = EffectCondition.of(new OnAttackedCondition());
    }

    static {
        MAP = new HashMap();
    }
}

