/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.conditions;

import com.robertx22.library_of_exile.registry.DataGenKey;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.EffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.stats.MarkerStat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.Arrays;
import net.minecraft.world.entity.Entity;

public class CasterHasStatCondition
extends EffectCondition {
    public CasterHasStatCondition() {
        super(Arrays.asList(MapField.SPELL_MODIFIER));
    }

    @Override
    public boolean canActivate(SpellCtx ctx, MapHolder data) {
        MarkerStat mod = (MarkerStat)ExileDB.Stats().get(data.get(MapField.SPELL_MODIFIER));
        return Load.Unit((Entity)ctx.caster).getUnit().getCalculatedStat(mod).getValue() > 0.0f;
    }

    public MapHolder create(DataGenKey<MarkerStat> mod) {
        MapHolder d = new MapHolder();
        d.type = this.GUID();
        d.put(MapField.SPELL_MODIFIER, mod.GUID());
        return d;
    }

    public String GUID() {
        return "caster_has_stat";
    }
}

