/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.conditions;

import com.robertx22.mine_and_slash.aoe_data.database.stats.base.EffectCtx;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.EffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.vanilla_mc.potion_effects.EntityStatusEffectsData;
import java.util.Arrays;
import net.minecraft.world.entity.Entity;

public class CasterHasMnsEffectCondition
extends EffectCondition {
    public CasterHasMnsEffectCondition() {
        super(Arrays.asList(MapField.EXILE_POTION_ID));
    }

    @Override
    public boolean canActivate(SpellCtx ctx, MapHolder data) {
        ExileEffect potion = data.getExileEffect();
        if (potion != null) {
            int stacks = data.getOrDefault(MapField.EFFECT_STACKS, 1.0).intValue();
            EntityStatusEffectsData d = Load.Unit((Entity)ctx.caster).getStatusEffectsData();
            return d.has(potion) && d.get((ExileEffect)potion).stacks >= stacks;
        }
        return false;
    }

    public MapHolder create(EffectCtx effect) {
        MapHolder d = new MapHolder();
        d.type = this.GUID();
        d.put(MapField.EXILE_POTION_ID, effect.id);
        return d;
    }

    public String GUID() {
        return "caster_has_mns_effect";
    }
}

