/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity.ParticleMotion;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity.ParticleShape;
import com.robertx22.mine_and_slash.database.data.spells.components.packets.ParticlesPacket;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ExileEffectUtils;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ParticleInRadiusAction
extends SpellAction {
    public ParticleInRadiusAction() {
        super(Arrays.asList(MapField.PARTICLE_TYPE, MapField.RADIUS, MapField.PARTICLE_COUNT));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        if (!ctx.world.f_46443_) {
            ParticleShape shape = data.getParticleShape();
            float radius = data.get(MapField.RADIUS).floatValue();
            radius *= ctx.calculatedSpellData.data.getNumber((String)EventData.AREA_MULTI, (float)1.0f).number;
            float height = data.getOrDefault(MapField.HEIGHT, 0.0).floatValue();
            int amount = data.get(MapField.PARTICLE_COUNT).intValue();
            amount = (int)((float)amount * ctx.calculatedSpellData.data.getNumber((String)EventData.AREA_MULTI, (float)1.0f).number);
            ParticleMotion motion = null;
            try {
                motion = ParticleMotion.valueOf(data.get(MapField.MOTION));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                motion = ParticleMotion.None;
            }
            float yrand = data.getOrDefault(MapField.Y_RANDOM, 0.0).floatValue();
            float motionMulti = data.getOrDefault(MapField.MOTION_MULTI, 1.0).floatValue();
            Vec3 pos = ctx.getPos();
            Vec3 vel = ExileEffectUtils.EnsureNotNaN(ctx.getPositionEntity().m_20184_());
            ParticlesPacket.Data saved = new ParticlesPacket.Data();
            saved.particle = data.get(MapField.PARTICLE_TYPE);
            saved.pos = pos;
            saved.motion = motion;
            saved.shape = shape;
            saved.casterAngle = ctx.caster.m_20154_();
            saved.amount = amount;
            saved.radius = radius;
            saved.height = height;
            saved.yrand = yrand;
            saved.motionMulti = motionMulti;
            saved.vel = vel;
            Packets.sendToTracking((MyPacket)new ParticlesPacket(saved), (BlockPos)ctx.getBlockPos(), (Level)ctx.world);
        }
    }

    public MapHolder create(SimpleParticleType particle, Double count, Double radius) {
        return this.create(particle, count, radius, ParticleMotion.None);
    }

    public MapHolder create(SimpleParticleType particle, Double count, Double radius, ParticleMotion motion) {
        MapHolder dmg = new MapHolder();
        dmg.type = this.GUID();
        dmg.put(MapField.RADIUS, radius);
        dmg.put(MapField.PARTICLE_COUNT, count);
        dmg.put(MapField.PARTICLE_TYPE, BuiltInRegistries.f_257034_.m_7981_((Object)particle).toString());
        dmg.put(MapField.MOTION, motion.name());
        return dmg;
    }

    public String GUID() {
        return "particles_in_radius";
    }
}

