/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.google.common.collect.Lists;
import com.robertx22.library_of_exile.utils.EntityUtils;
import com.robertx22.library_of_exile.utils.geometry.MyPosition;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class TeleportTargetToSourceAction
extends SpellAction {
    private static final List<Vec3i> SEARCH_OFFSETS = Lists.newArrayList();

    public TeleportTargetToSourceAction() {
        super(Arrays.asList(new MapField[0]));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        targets.forEach(x -> {
            if (x.m_9236_() == ctx.sourceEntity.m_9236_()) {
                this.teleportEntitySafe((LivingEntity)x, ctx.sourceEntity.m_20182_());
            }
        });
    }

    public void teleportEntitySafe(LivingEntity entity, Vec3 destination) {
        Vec3 tpPosition = this.findSafeTeleportPosition((Entity)entity, destination).m_82520_(0.0, (double)(-entity.m_20206_()) / 2.0, 0.0);
        EntityUtils.setLoc((LivingEntity)entity, (Vector3d)new MyPosition(tpPosition).asVector3D(), (float)entity.m_146908_(), (float)entity.m_146909_());
    }

    private Vec3 findSafeTeleportPosition(Entity entity, Vec3 destination) {
        Vec3 safePosition = this.findNearbySafeTeleportPosition(entity, destination);
        if (safePosition == null) {
            return destination;
        }
        AABB aabb = this.makeAabbForPosition(entity, safePosition);
        Vec3 delta = destination.m_82546_(safePosition);
        List entityCollisions = entity.m_9236_().m_183134_(entity, aabb.m_82369_(delta));
        Vec3 clippedDelta = Entity.m_198894_((Entity)entity, (Vec3)delta, (AABB)aabb, (Level)entity.m_9236_(), (List)entityCollisions);
        return safePosition.m_82549_(clippedDelta);
    }

    private Vec3 findNearbySafeTeleportPosition(Entity entity, Vec3 destination) {
        Vec3 adjustedDestination = this.nudgePositionOutOfBlock(entity, destination);
        BlockPos blockPos = BlockPos.m_274446_((Position)adjustedDestination);
        double yAdjust = (double)entity.m_20206_() / 2.0 - 0.5;
        for (Vec3i offset : SEARCH_OFFSETS) {
            Vec3 testPosition = blockPos.m_121955_(offset).m_252807_().m_82520_(0.0, yAdjust, 0.0);
            if (!this.canEntityFit(entity, testPosition)) continue;
            return testPosition;
        }
        return null;
    }

    private Vec3 nudgePositionOutOfBlock(Entity entity, Vec3 destination) {
        double NUDGE_SCALE = 1.0E-6;
        for (Vec3i offset : SEARCH_OFFSETS) {
            Vec3 testPosition = destination.m_82549_(new Vec3((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_()).m_82490_(1.0E-6));
            if (!this.canPointFit(entity, testPosition, 1.0E-6)) continue;
            return testPosition;
        }
        return destination;
    }

    private boolean canPointFit(Entity entity, Vec3 destination, double size) {
        return entity.m_9236_().m_45756_(entity, AABB.m_165882_((Vec3)destination, (double)size, (double)size, (double)size));
    }

    private boolean canEntityFit(Entity entity, Vec3 destination) {
        return entity.m_9236_().m_45756_(entity, this.makeAabbForPosition(entity, destination));
    }

    private AABB makeAabbForPosition(Entity entity, Vec3 position) {
        return AABB.m_165882_((Vec3)position, (double)entity.m_20205_(), (double)entity.m_20206_(), (double)entity.m_20205_());
    }

    public MapHolder create() {
        MapHolder c = new MapHolder();
        c.type = this.GUID();
        this.validate(c);
        return c;
    }

    public String GUID() {
        return "tp_target_to_self";
    }

    static {
        boolean SEARCH_RADIUS = true;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    SEARCH_OFFSETS.add(new Vec3i(x, y, z));
                }
            }
        }
        SEARCH_OFFSETS.sort((a, b) -> {
            int bDistance;
            int aDistance = Math.abs(a.m_123341_()) + Math.abs(a.m_123343_());
            if (aDistance == (bDistance = Math.abs(b.m_123341_()) + Math.abs(b.m_123343_()))) {
                return Math.abs(a.m_123342_()) - Math.abs(b.m_123342_());
            }
            return aDistance - bDistance;
        });
    }
}

