/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.robertx22.mine_and_slash.aoe_data.database.spells.SummonType;
import com.robertx22.mine_and_slash.capability.entity.SummonedPetData;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.spells.summons.entity.SummonEntity;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class SummonPetAction
extends SpellAction {
    public static int INFINITE_DURATION = -1;

    public SummonPetAction() {
        super(Arrays.asList(new MapField[0]));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        if (ctx.world.f_46443_) {
            return;
        }
        int amount = data.getOrDefault(MapField.COUNT, 1.0).intValue();
        for (int i = 0; i < amount; ++i) {
            Optional type = EntityType.m_20632_((String)data.get(MapField.SUMMONED_PET_ID));
            TamableAnimal en = (TamableAnimal)((EntityType)type.get()).m_20615_(ctx.world);
            en.m_6518_((ServerLevelAccessor)((ServerLevel)ctx.world), ctx.world.m_6436_(ctx.getBlockPos()), MobSpawnType.MOB_SUMMONED, null, null);
            en.m_21828_((Player)ctx.caster);
            Vec3 pos = ctx.caster.m_20182_();
            en.m_6034_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            int duration = SummonPetAction.getDuration(ctx, data);
            float aggroRadius = ctx.calculatedSpellData.data.getNumber((String)EventData.AGGRO_RADIUS, (float)15.0f).number;
            boolean counts = data.getOrDefault(MapField.COUNTS_TOWARDS_MAX_SUMMONS, true);
            Load.Unit((Entity)en).summonedPetData.setup(ctx.calculatedSpellData.getSpell(), duration, (int)(aggroRadius *= ctx.calculatedSpellData.data.getNumber((String)EventData.AGGRO_RADIUS_MULTI, (float)1.0f).number), counts);
            Load.Unit((Entity)en).SetMobLevelAtSpawn((Player)ctx.caster);
            Load.Unit((Entity)en).setLevel(Load.Unit((Entity)ctx.caster).getLevel());
            Load.Unit((Entity)en).setRarity("summon");
            ctx.world.m_7967_((Entity)en);
        }
        int totalSummons = (int)ctx.calculatedSpellData.data.getNumber((String)EventData.BONUS_TOTAL_SUMMONS, (float)0.0f).number;
        SummonPetAction.updatePlayerSummons(ctx.caster, totalSummons, ctx.calculatedSpellData.spell_id);
    }

    private static int getDuration(SpellCtx ctx, MapHolder data) {
        int duration = data.get(MapField.LIFESPAN_TICKS).intValue();
        if (duration == INFINITE_DURATION) {
            return duration;
        }
        return (int)((float)duration * ctx.calculatedSpellData.data.getNumber((String)EventData.DURATION_MULTI, (float)1.0f).number);
    }

    public static void updatePlayerSummons(LivingEntity caster, int totalSummons, String currentSummonSpell) {
        ArrayList<NearbySummon> summonsNearby = new ArrayList<NearbySummon>();
        int summonsTowardsMax = 0;
        for (SummonEntity en : EntityFinder.start((Entity)caster, SummonEntity.class, caster.m_20183_()).searchFor(AllyOrEnemy.all).radius(100.0).build()) {
            if (en.m_269323_() != caster) continue;
            SummonedPetData data = Load.Unit((Entity)en).summonedPetData;
            if (data.counts_towards_max_summons) {
                ++summonsTowardsMax;
            }
            summonsNearby.add(new NearbySummon(en, data));
        }
        summonsNearby.sort(Comparator.comparingInt(x -> -x.summon.f_19797_));
        int excess = summonsTowardsMax - totalSummons;
        for (int i = 0; excess > 0 && i < summonsNearby.size(); ++i) {
            NearbySummon summonToRemove = (NearbySummon)summonsNearby.get(i);
            if (!summonToRemove.data.counts_towards_max_summons) continue;
            summonToRemove.data.discard((LivingEntity)summonToRemove.summon);
            summonsNearby.remove(i);
            --excess;
            --i;
        }
        summonsNearby.trimToSize();
        HashMap<String, List> summonedTypes = new HashMap<String, List>();
        for (int i = 0; i < summonsNearby.size(); ++i) {
            NearbySummon summonToRemove = (NearbySummon)summonsNearby.get(i);
            if (!summonedTypes.containsKey(summonToRemove.data.spell)) {
                summonedTypes.put(summonToRemove.data.spell, new ArrayList());
            }
            ((List)summonedTypes.get(summonToRemove.data.spell)).add(summonToRemove.summon.m_20148_());
        }
        if (!(caster instanceof Player)) {
            return;
        }
        Player player = (Player)caster;
        summonedTypes.forEach((spell, summons) -> Load.player(player).setSummons((String)spell, (List<UUID>)summons));
    }

    public MapHolder create(EntityType type, int lifespan, int amount, SummonType st, boolean counts) {
        MapHolder c = new MapHolder();
        c.put(MapField.SUMMON_TYPE, st.name());
        c.put(MapField.SUMMONED_PET_ID, EntityType.m_20613_((EntityType)type).toString());
        c.put(MapField.ENTITY_NAME, Spell.DEFAULT_EN_NAME);
        c.put(MapField.LIFESPAN_TICKS, Double.valueOf(lifespan));
        c.put(MapField.COUNT, Double.valueOf(amount));
        c.put(MapField.COUNTS_TOWARDS_MAX_SUMMONS, counts);
        c.type = this.GUID();
        return c;
    }

    public String GUID() {
        return "summon_pet";
    }

    private static class NearbySummon {
        public SummonEntity summon;
        public SummonedPetData data;

        public NearbySummon(SummonEntity summon, SummonedPetData data) {
            this.summon = summon;
            this.data = data;
        }
    }
}

