/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;

public class SummonAtTargetFeet
extends SpellAction {
    public SummonAtTargetFeet() {
        super(Arrays.asList(MapField.ENTITY_NAME, MapField.PROJECTILE_ENTITY, MapField.LIFESPAN_TICKS, MapField.HEIGHT));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        Optional projectile = EntityType.m_20632_((String)data.get(MapField.PROJECTILE_ENTITY));
        Double height = data.getOrDefault(MapField.HEIGHT, 0.0);
        targets.forEach(x -> {
            Vec3 pos = x.m_20182_();
            Entity en = ((EntityType)projectile.get()).m_20615_(ctx.world);
            SpellUtils.initSpellEntity(en, ctx.caster, ctx.calculatedSpellData, data);
            en.m_6034_(pos.f_82479_, pos.f_82480_ + height, pos.f_82481_);
            ctx.caster.m_9236_().m_7967_(en);
        });
    }

    public MapHolder create(Item item, EntityType type, Double lifespan) {
        MapHolder c = new MapHolder();
        c.put(MapField.PROJECTILE_COUNT, 1.0);
        c.put(MapField.ENTITY_NAME, Spell.DEFAULT_EN_NAME);
        c.put(MapField.PROJECTILE_SPEED, 0.0);
        c.put(MapField.LIFESPAN_TICKS, lifespan);
        c.put(MapField.ITEM, VanillaUTIL.REGISTRY.items().getKey((Object)item).toString());
        c.put(MapField.GRAVITY, false);
        c.put(MapField.PROJECTILE_ENTITY, EntityType.m_20613_((EntityType)type).toString());
        c.type = this.GUID();
        return c;
    }

    public String GUID() {
        return "summon_at_target_feet";
    }
}

