/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.spells.components.ComponentPart;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.tags.imp.EffectTag;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DoActionForEachEffectOnTarget
extends SpellAction {
    public DoActionForEachEffectOnTarget() {
        super(Arrays.asList(new MapField[0]));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        try {
            if (ctx.world.f_46443_) {
                return;
            }
            String action = data.get(MapField.SPECIFIC_ACTION);
            String tag = data.get(MapField.EFFECT_TAG);
            int amount = 0;
            for (LivingEntity x : targets) {
                for (String k : Load.Unit((Entity)x).getStatusEffectsData().exileMap.keySet()) {
                    ExileEffect eff = (ExileEffect)ExileDB.ExileEffects().get(k);
                    if (!eff.hasTag(tag)) continue;
                    ++amount;
                }
            }
            for (int i = 0; i < amount; ++i) {
                for (ComponentPart componentPart : ctx.calculatedSpellData.getSpell().attached.entity_components.get(action)) {
                    componentPart.tryActivate(ctx);
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public MapHolder create(String action, EffectTag tag) {
        MapHolder c = new MapHolder();
        c.put(MapField.SPECIFIC_ACTION, action);
        c.put(MapField.EFFECT_TAG, tag.GUID());
        c.type = this.GUID();
        this.validate(c);
        return c;
    }

    public String GUID() {
        return "action_per_effect_with_tag_on_target";
    }
}

