/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.value_calc.ValueCalculation;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.GenerateThreatEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.ThreatGenType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;

public class AggroAction
extends SpellAction {
    public AggroAction() {
        super(Arrays.asList(MapField.AGGRO_TYPE));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        if (ctx.caster instanceof Player) {
            ValueCalculation calc = data.get(MapField.VALUE_CALCULATION);
            int num = calc.getCalculatedValue(ctx.caster, ctx.calculatedSpellData.getSpell());
            Type aggro = data.getAggro();
            targets.forEach(x -> {
                if (x instanceof Mob) {
                    Mob mob = (Mob)x;
                    if (aggro == Type.AGGRO) {
                        GenerateThreatEvent event = new GenerateThreatEvent((LivingEntity)((Player)ctx.caster), mob, ThreatGenType.spell, num);
                        event.Activate();
                    } else {
                        Load.Unit((Entity)mob).getThreat().addThreat((LivingEntity)((Player)ctx.caster), mob, -num);
                    }
                }
            });
        }
    }

    public MapHolder create(ValueCalculation calc, Type type) {
        MapHolder d = new MapHolder();
        d.type = this.GUID();
        d.put(MapField.AGGRO_TYPE, type.name());
        d.put(MapField.VALUE_CALCULATION, calc);
        return d;
    }

    public String GUID() {
        return "aggro";
    }

    public static enum Type {
        AGGRO,
        DE_AGGRO;

    }
}

