/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.tooltip.ExileTooltipUtils;
import com.robertx22.library_of_exile.util.UNICODE;
import com.robertx22.library_of_exile.wrappers.ExileText;
import com.robertx22.mine_and_slash.a_libraries.player_animations.AnimationHolder;
import com.robertx22.mine_and_slash.a_libraries.player_animations.PlayerAnimations;
import com.robertx22.mine_and_slash.a_libraries.player_animations.SpellAnimations;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellDesc;
import com.robertx22.mine_and_slash.config.forge.compat.CompatConfig;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.spells.components.AttachedSpell;
import com.robertx22.mine_and_slash.database.data.spells.components.ComponentPart;
import com.robertx22.mine_and_slash.database.data.spells.components.SpellAnimationData;
import com.robertx22.mine_and_slash.database.data.spells.components.SpellConfiguration;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SummonPetAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.data.stats.tooltips.SummonTooltip;
import com.robertx22.mine_and_slash.database.data.value_calc.MaxLevelProvider;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.ISkillGem;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellCastingData;
import com.robertx22.mine_and_slash.saveclasses.unit.GearData;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import com.robertx22.mine_and_slash.tags.all.SpellTags;
import com.robertx22.mine_and_slash.tags.imp.SpellTag;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpendResourceEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.enumclasses.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.MapManager;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.lang.invoke.LambdaMetafactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public final class Spell
implements ISkillGem,
IGUID,
IAutoGson<Spell>,
JsonExileRegistry<Spell>,
IAutoLocName,
IAutoLocDesc,
MaxLevelProvider {
    public static Spell SERIALIZER = new Spell();
    public static String DEFAULT_EN_NAME = "default_entity_name";
    public static String CASTER_NAME = "caster";
    public int weight = 1000;
    public String identifier = "";
    public AttachedSpell attached = new AttachedSpell();
    public SpellConfiguration config = new SpellConfiguration();
    public SpellAnimationData cast_animation = new SpellAnimationData(SpellAnimations.STEADY_CAST);
    public SpellAnimationData cast_finish_animation = new SpellAnimationData(SpellAnimations.CAST_FINISH);
    public int min_lvl = 1;
    public int default_lvl = 0;
    public String lvl_based_on_spell = "";
    public String show_other_spell_tooltip = "";
    public boolean manual_tip = false;
    public List<String> disabled_dims = new ArrayList<String>();
    public String effect_tip = "";
    public int max_lvl = 16;
    public List<StatMod> statsForSkillGem = new ArrayList<StatMod>();
    public transient String locDesc = "";
    private static final DecimalFormat TOOLTIP_NUMBER_FORMAT = new DecimalFormat("0.##");
    public String loc_name;

    public Boolean hasCost(ResourceType type) {
        if (type == ResourceType.energy) {
            return this.config.ene_cost.min > 0.0f;
        }
        if (type == ResourceType.mana) {
            return this.config.mana_cost.min > 0.0f;
        }
        return null;
    }

    public boolean usesWeaponForDamage() {
        return true;
    }

    public boolean isAllowedInDimension(Level world) {
        if (this.disabled_dims.isEmpty()) {
            return true;
        }
        return this.disabled_dims.stream().map(x -> new ResourceLocation(x)).noneMatch(x -> x.equals((Object)MapManager.getResourceLocation(world)));
    }

    public AttachedSpell getAttached() {
        return this.attached;
    }

    public List<ExactStatData> getStats(Player p) {
        int perc = (int)((float)this.getLevelOf((LivingEntity)p) / (float)this.getMaxLevelWithBonuses() * 100.0f);
        List<ExactStatData> stats = this.statsForSkillGem.stream().map(x -> x.ToExactStat(perc, Load.Unit((Entity)p).getLevel())).collect(Collectors.toList());
        return stats;
    }

    public boolean is(SpellTag tag) {
        return this.config.tags.contains(tag);
    }

    public SpellConfiguration getConfig() {
        return this.config;
    }

    public void validate() {
        for (ComponentPart x : this.attached.getAllComponents()) {
            x.validate();
        }
    }

    public final ResourceLocation getIconLoc() {
        return Spell.getIconLoc(this.GUID());
    }

    public static final ResourceLocation getIconLoc(String id) {
        return new ResourceLocation("mmorpg", "textures/gui/spells/icons/" + id + ".png");
    }

    public WeaponTypes getWeapon(LivingEntity en) {
        try {
            GearData wep;
            if (this.getStyle() != PlayStyle.INT && (wep = Load.Unit((Entity)en).equipmentCache.getWeapon()) != null && wep.gear != null) {
                return wep.gear.GetBaseGearType().weaponType();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return WeaponTypes.none;
    }

    public final void onCastingTick(SpellCastContext ctx) {
        int timesToCast = ctx.spell.getConfig().times_to_cast;
        if (timesToCast > 1) {
            int castCountLastTick;
            int castTimeTicks = this.getCastTimeTicks(ctx);
            int castCountThisTick = ctx.ticksInUse * timesToCast / castTimeTicks;
            if (castCountThisTick != (castCountLastTick = (ctx.ticksInUse - 1) * timesToCast / castTimeTicks)) {
                this.cast(ctx);
            }
        } else if (timesToCast < 1) {
            ExileLog.get().warn("Times to cast spell is: " + timesToCast + " . this seems like a bug.", new Object[0]);
        }
    }

    public void cast(SpellCastContext ctx) {
        LivingEntity caster = ctx.caster;
        ctx.castedThisTick = true;
        this.attached.onCast(SpellCtx.onCast(caster, ctx.calcData));
    }

    public final int getCooldownTicks(SpellCastContext ctx) {
        return (int)Math.ceil(ctx.event.data.getNumber((String)EventData.COOLDOWN_TICKS).number);
    }

    public final int getChargeCooldownTicks(SpellCastContext ctx) {
        return (int)Math.ceil(ctx.event.data.getNumber((String)EventData.CHARGE_COOLDOWN_TICKS).number);
    }

    public final int getCastTimeTicks(SpellCastContext ctx) {
        return MathHelper.clamp((int)Math.ceil(ctx.event.data.getNumber((String)EventData.CAST_TICKS).number), this.config.times_to_cast, 10000);
    }

    public String GUID() {
        return this.identifier;
    }

    public void spendResources(SpellCastContext ctx) {
        this.getManaCostCtx(ctx).Activate();
        this.getEnergyCostCtx(ctx).Activate();
    }

    public SpendResourceEvent getManaCostCtx(SpellCastContext ctx) {
        float cost = this.getCalculatedManaCost(ctx);
        SpendResourceEvent event = new SpendResourceEvent(ctx.caster, this, ResourceType.mana, cost);
        event.calculateEffects();
        return event;
    }

    public SpendResourceEvent getEnergyCostCtx(SpellCastContext ctx) {
        float cost = this.getCalculatedEnergyCost(ctx);
        SpendResourceEvent event = new SpendResourceEvent(ctx.caster, this, ResourceType.energy, cost);
        event.calculateEffects();
        return event;
    }

    public final int getCalculatedManaCost(SpellCastContext ctx) {
        return (int)ctx.event.data.getNumber((String)EventData.MANA_COST).number;
    }

    public final int getCalculatedEnergyCost(SpellCastContext ctx) {
        return (int)ctx.event.data.getNumber((String)EventData.ENERGY_COST).number;
    }

    public final List<Component> GetTooltipString(StatRangeInfo info) {
        List<Spell> others;
        SpellCastContext ctx = new SpellCastContext((LivingEntity)info.player, 0, this);
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)this.locName().m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        list.add((Component)ExileText.emptyLine().get());
        SpellDesc.getTooltip(ctx.caster, this).forEach(x -> list.add((Component)Component.m_237113_((String)x)));
        list.add((Component)ExileText.emptyLine().get());
        int mana = this.getCalculatedManaCost(ctx);
        int ene = this.getCalculatedEnergyCost(ctx);
        if (mana > 0) {
            list.add((Component)Words.MANA_COST.locName(mana).m_130940_(ChatFormatting.BLUE));
        }
        if (ene > 0) {
            list.add((Component)Words.ENE_COST.locName(ene).m_130940_(ChatFormatting.GREEN));
        }
        if (this.config.usesCharges()) {
            list.add((Component)Words.MAX_CHARGES.locName(this.config.charges).m_130940_(ChatFormatting.YELLOW));
            list.add((Component)Words.CHARGE_REGEN.locName(Spell.tooltipFormatTicksAsSeconds(this.config.charge_regen)).m_130940_(ChatFormatting.YELLOW));
        } else {
            list.add((Component)Words.COOLDOWN.locName(Spell.tooltipFormatTicksAsSeconds(this.getCooldownTicks(ctx))).m_130940_(ChatFormatting.YELLOW));
        }
        int casttime = this.getCastTimeTicks(ctx);
        if (casttime <= 1) {
            list.add((Component)Words.INSTANT_CAST.locName().m_130940_(ChatFormatting.GREEN));
        } else {
            list.add((Component)Words.CAST_TIME.locName(Spell.tooltipFormatTicksAsSeconds(casttime)).m_130940_(ChatFormatting.GREEN));
        }
        LinkedHashSet radiuses = new LinkedHashSet();
        this.getAttached().getAllComponents().forEach(x -> x.targets.forEach(a -> {
            if (x.acts.stream().anyMatch(e -> e.type.equals(SpellAction.DEAL_DAMAGE.GUID())) && a.has(MapField.RADIUS)) {
                String rad = TOOLTIP_NUMBER_FORMAT.format(a.getOrDefault(MapField.RADIUS, 0.0));
                radiuses.add(rad);
            }
        }));
        for (String radius : radiuses) {
            list.add((Component)Words.Radius.locName(radius).m_130940_(ChatFormatting.GOLD));
        }
        list.add((Component)ExileText.emptyLine().get());
        if (!CompatConfig.get().ignoreWeaponReqForSpells()) {
            list.add((Component)this.getConfig().castingWeapon.predicate.text);
        }
        list.add((Component)ExileText.emptyLine().get());
        if (this.config.times_to_cast > 1) {
            list.add((Component)ExileText.emptyLine().get());
            list.add((Component)Words.CASTED_TIMES_CHANNEL.locName(this.config.times_to_cast).m_130940_(ChatFormatting.RED));
        }
        boolean showeffect = Screen.m_96638_();
        LinkedHashMap<ExileEffect, String> effectsWithDurations = new LinkedHashMap<ExileEffect, String>();
        if (ExileDB.ExileEffects().isRegistered(this.effect_tip)) {
            effectsWithDurations.put((ExileEffect)ExileDB.ExileEffects().get(this.effect_tip), "");
        }
        ArrayList summons = new ArrayList();
        try {
            this.getAttached().getAllComponents().forEach(x -> x.acts.forEach(a -> {
                if (a.has(MapField.EXILE_POTION_ID)) {
                    ExileEffect eff = a.getExileEffect();
                    String dur = Spell.tooltipFormatTicksAsSeconds((int)a.getOrDefault(MapField.POTION_DURATION, 0.0).doubleValue());
                    if (effectsWithDurations.containsKey(eff)) {
                        float oldDur;
                        String existingDur = (String)effectsWithDurations.get(eff);
                        float newDur = Spell.parseDuration(dur);
                        if (newDur > (oldDur = Spell.parseDuration(existingDur))) {
                            effectsWithDurations.put(eff, dur);
                        }
                    } else {
                        effectsWithDurations.put(eff, dur);
                    }
                }
                if (a.has(MapField.SUMMONED_PET_ID)) {
                    float duration = a.get(MapField.LIFESPAN_TICKS).intValue();
                    Optional type = EntityType.m_20632_((String)a.get(MapField.SUMMONED_PET_ID));
                    String name = Words.SUMMON_UNKNOWN_ENTITY.locNameLangFileGUID();
                    if (type.isPresent()) {
                        name = ((EntityType)type.get()).m_20675_();
                    }
                    String finalName = name;
                    if (summons.stream().filter(i -> i.type().equals(finalName) && i.duration() == duration).findAny().isEmpty()) {
                        summons.add(new SummonTooltip(name, duration));
                    }
                }
                if (a.has(MapField.make(MapField.BLOCK))) {
                    float duration = a.get(MapField.LIFESPAN_TICKS).intValue();
                    String name = this.loc_name;
                    if (summons.stream().filter(i -> i.type().equals(name) && i.duration() == duration).findAny().isEmpty()) {
                        summons.add(new SummonTooltip(name, duration));
                    }
                }
            }));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MutableComponent showEffectTip = null;
        try {
            if (showeffect) {
                for (Map.Entry entry : effectsWithDurations.entrySet()) {
                    ExileEffect effect = (ExileEffect)entry.getKey();
                    String duration = (String)entry.getValue();
                    list.add((Component)effect.locName().m_130940_(ChatFormatting.BLUE));
                    list.add((Component)(effect.max_stacks > 1 ? Words.Stats.locName().m_7220_((Component)Words.PER_STACK.locName()).m_130940_(ChatFormatting.GREEN) : Words.Stats.locName().m_130940_(ChatFormatting.GREEN)));
                    List<ExactStatData> stats = effect.getExactStats(ctx.caster, this, 1, 1.0f);
                    for (ExactStatData stat : stats) {
                        list.addAll(stat.GetTooltipString());
                    }
                    if (duration != null && !duration.isEmpty()) {
                        list.add((Component)Words.LASTS_SEC.locName(duration));
                    }
                    list.add((Component)ExileText.emptyLine().get());
                }
            } else if (!effectsWithDurations.isEmpty()) {
                showEffectTip = Words.SHIFT_TO_SHOW_EFFECT.locName().m_130940_(ChatFormatting.BLUE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!summons.isEmpty()) {
            list.add((Component)Words.SUMMONS_LIST.locName());
        }
        for (SummonTooltip summon : summons) {
            list.add((Component)Component.m_237115_((String)summon.type()).m_130940_(ChatFormatting.BLUE));
            MutableComponent durationValue = Component.m_237113_((String)String.valueOf(summon.duration() / 20.0f));
            if (summon.duration() == (float)SummonPetAction.INFINITE_DURATION) {
                durationValue = Words.SUMMON_IS_INFINITE.locName();
            }
            list.add((Component)durationValue.m_130940_(ChatFormatting.GREEN).m_7220_((Component)Words.UNIT_SECOND.locName()).m_130946_(" ").m_7220_((Component)Words.SUMMON_BASE_DURATION.locName().m_130940_(ChatFormatting.GRAY)));
            list.add((Component)ExileText.emptyLine().get());
        }
        if (!this.statsForSkillGem.isEmpty()) {
            list.add((Component)Words.SPELL_STATS.locName());
            for (ExactStatData stat : this.getStats(info.player)) {
                list.addAll(stat.GetTooltipString());
            }
        }
        MutableComponent taglist = ExileTooltipUtils.joinMutableComps(this.config.tags.getTags(SpellTag.SERIALIZER).stream().map(x -> x.locName()).iterator(), (MutableComponent)Gui.COMMA_SEPARATOR.locName());
        MutableComponent tagtext = Words.TAGS.locName().m_7220_((Component)taglist);
        list.add((Component)tagtext);
        if (showEffectTip != null) {
            list.add((Component)showEffectTip);
        }
        if (info.hasShiftDown && this.config.tags.contains(SpellTags.has_pet_ability)) {
            list.clear();
            list.add((Component)Words.PET_BASIC.locName());
            Spell spell = this.config.getSummonBasicSpell();
            list.addAll(spell.GetTooltipString(info));
        }
        if (!this.show_other_spell_tooltip.isEmpty()) {
            if (info.hasAltDown) {
                list.clear();
                Spell other = (Spell)ExileDB.Spells().get(this.show_other_spell_tooltip);
                list.addAll(other.GetTooltipString(info));
            } else {
                list.add((Component)Chats.ALT_TO_SHOW_OTHER_SPELL.locName().m_130940_(ChatFormatting.BLUE));
            }
        }
        if (!(others = this.getSpellsThatBenefitFromSupportGemsOfThis()).isEmpty()) {
            MutableComponent merged = ExileTooltipUtils.joinMutableComps(others.stream().map(x -> x.locName()).iterator(), (MutableComponent)Component.m_237113_((String)", "));
            list.add((Component)Component.m_237113_((String)(UNICODE.STAR + " ")).m_7220_((Component)Words.SUPPORT_GEMS_ALSO_BENEFIT.locName(merged)).m_130940_(ChatFormatting.GREEN));
        }
        if (showEffectTip == null) {
            list.add((Component)Itemtips.SHIFT_TIP.locName().m_130940_(ChatFormatting.BLUE).m_130946_(" "));
        }
        TooltipUtils.removeDoubleBlankLines(list);
        return list;
    }

    private static float parseDuration(String dur) {
        if (dur == null || dur.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(dur);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private static String tooltipFormatTicksAsSeconds(int ticks) {
        return TOOLTIP_NUMBER_FORMAT.format((float)ticks / 20.0f);
    }

    public int getLevelOf(LivingEntity en) {
        if (!this.lvl_based_on_spell.isEmpty()) {
            Spell other = (Spell)ExileDB.Spells().get(this.lvl_based_on_spell);
            if (!other.lvl_based_on_spell.equals(this.lvl_based_on_spell)) {
                return other.getLevelOf(en);
            }
        }
        int lvl = 0;
        if (en instanceof Player) {
            Player p = (Player)en;
            Optional<SpellCastingData.InsertedSpell> opt = Load.player((Player)p).spellCastingData.getAllHotbarSpells().stream().filter(x -> x.id.equals(this.GUID())).findAny();
            if (opt.isPresent()) {
                lvl = opt.get().rank;
            }
        }
        if (lvl < this.default_lvl) {
            lvl = this.default_lvl;
        }
        return lvl;
    }

    public List<Spell> getSpellsThatBenefitFromSupportGemsOfThis() {
        return ExileDB.Spells().getFilterWrapped((Predicate<Spell>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getSpellsThatBenefitFromSupportGemsOfThis$14(com.robertx22.mine_and_slash.database.data.spells.components.Spell ), (Lcom/robertx22/mine_and_slash/database/data/spells/components/Spell;)Z)((Spell)this)).list;
    }

    public AnimationHolder getAnimation(PlayerAnimations.CastEnum e) {
        if (e == PlayerAnimations.CastEnum.CAST_START) {
            return this.cast_animation.getAnim();
        }
        if (e == PlayerAnimations.CastEnum.CAST_FINISH) {
            return this.cast_finish_animation.getAnim();
        }
        return AnimationHolder.none();
    }

    public Class<Spell> getClassForSerialization() {
        return Spell.class;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.SPELL;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Spells;
    }

    public int Weight() {
        return this.weight;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.spell." + this.GUID();
    }

    @Override
    public String locNameForLangFile() {
        return this.loc_name;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locDescGroup() {
        return IBaseAutoLoc.AutoLocGroup.Spells;
    }

    @Override
    public String locDescLangFileGUID() {
        return "spell.desc." + this.GUID();
    }

    @Override
    public String locDescForLangFile() {
        return this.locDesc;
    }

    @Override
    public int getCurrentLevel(LivingEntity en) {
        return this.getLevelOf(en);
    }

    @Override
    public int getMaxLevel() {
        return this.max_lvl;
    }

    @Override
    public int getMaxLevelWithBonuses() {
        return this.getMaxLevel() + GameBalanceConfig.get().MAX_BONUS_SPELL_LEVELS;
    }

    @Override
    public int getRequiredLevel() {
        return this.min_lvl;
    }

    @Override
    public PlayStyle getStyle() {
        return this.config.getStyle();
    }

    private /* synthetic */ boolean lambda$getSpellsThatBenefitFromSupportGemsOfThis$14(Spell x) {
        return x.config.use_support_gems_from.equals(this.GUID());
    }

    private static class EffectWithDuration {
        public final ExileEffect effect;
        public final String duration;

        public EffectWithDuration(ExileEffect effect, String duration) {
            this.effect = effect;
            this.duration = duration;
        }
    }
}

