/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components;

import com.robertx22.library_of_exile.utils.geometry.MyPosition;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.AoeSelector;
import com.robertx22.mine_and_slash.database.data.spells.entities.CalculatedSpellData;
import com.robertx22.mine_and_slash.database.data.spells.entities.IDatapackProjectileEntity;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellUtils;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3f;

public class ProjectileCastHelper {
    LivingEntity caster;
    public boolean silent = false;
    public float apart = 3.0f;
    public float shootSpeed = 1.0f;
    public int projectilesAmount = 1;
    public float randomSpreadDegrees = 0.0f;
    public boolean gravity = true;
    public int lifespanTicks = -1;
    EntityType projectile;
    CalculatedSpellData data;
    MapHolder holder;
    Vec3 pos;
    public CastType castType = CastType.SPREAD_OUT_IN_RADIUS;
    public float pitch;
    public float pitchOffset;
    public float yaw;
    public float yawOffset;
    public double offsetX;
    public double offsetY;
    public double offsetZ;
    public boolean fallDown = false;
    public boolean targetEnemy = false;
    SpellCtx ctx;

    public ProjectileCastHelper(SpellCtx ctx, Vec3 pos, MapHolder holder, LivingEntity caster, EntityType projectile, CalculatedSpellData data) {
        this.ctx = ctx;
        this.projectile = projectile;
        this.caster = caster;
        this.data = data;
        this.holder = holder;
        this.pos = pos;
        this.pitch = caster.m_146909_();
        this.yaw = caster.m_146908_();
    }

    public void cast() {
        if (this.data.data.getBoolean(EventData.BARRAGE)) {
            this.castType = CastType.SPREAD_OUT_HORIZONTAL;
        }
        Level world = this.caster.m_9236_();
        LivingEntity target = null;
        Vec3 baseDirection = null;
        if (this.targetEnemy) {
            double radius = this.calculateRadius();
            double radiusSqr = radius * radius;
            EntityFinder.Setup<LivingEntity> finder = EntityFinder.start((Entity)this.caster, LivingEntity.class, this.pos.m_82520_(0.0, 0.0, 0.0)).finder(EntityFinder.SelectionType.RADIUS).searchFor(AllyOrEnemy.enemies).predicate(e -> e.m_20238_(this.ctx.getPos()) <= radiusSqr && AoeSelector.canHit(this.ctx.getPos(), (Entity)e)).radius(radius);
            target = finder.getClosest();
            if (target == null) {
                return;
            }
            baseDirection = ProjectileCastHelper.positionToVelocity(new MyPosition(this.pos), new MyPosition(target.m_146892_()));
            this.pitch = (float)Math.asin((double)(-baseDirection.f_82480_)) * 57.295776f;
            this.yaw = (float)Math.atan2((double)(-baseDirection.f_82479_), (double)baseDirection.f_82481_) * 57.295776f;
        }
        for (int i = 0; i < this.projectilesAmount; ++i) {
            float multiProjYawOffset = 0.0f;
            Vec3 posAdd = new Vec3(0.0, 0.0, 0.0);
            if (this.projectilesAmount > 1) {
                float offset = (float)i - (float)(this.projectilesAmount - 1) / 2.0f;
                if (this.castType == CastType.SPREAD_OUT_IN_RADIUS) {
                    multiProjYawOffset = offset * this.apart / (float)this.projectilesAmount;
                } else if (this.castType == CastType.SPREAD_OUT_HORIZONTAL) {
                    posAdd = this.getSideVelocity((Entity)this.caster).m_82490_((double)offset);
                }
            }
            float randomYawOffset = 0.0f;
            float randomPitchOffset = 0.0f;
            if (this.randomSpreadDegrees > 0.0f) {
                randomYawOffset = (float)((Math.random() * 2.0 - 1.0) * (double)this.randomSpreadDegrees);
                randomPitchOffset = (float)((Math.random() * 2.0 - 1.0) * (double)this.randomSpreadDegrees);
            }
            posAdd = posAdd.m_82549_(this.getSideVelocity((Entity)this.caster).m_82490_(this.offsetX));
            posAdd = posAdd.m_82549_(this.caster.m_20289_(1.0f).m_82490_(this.offsetY));
            posAdd = posAdd.m_82549_(this.caster.m_20252_(1.0f).m_82490_(this.offsetZ));
            AbstractArrow en = (AbstractArrow)this.projectile.m_20615_(world);
            SpellUtils.setUpProjectilePosition(this.pos.m_82549_(posAdd), en, this.ctx.getPositionEntity());
            SpellUtils.initSpellEntity((Entity)en, this.caster, this.data, this.holder);
            float totalPitchOffset = this.pitchOffset + randomPitchOffset;
            float totalYawOffset = this.yawOffset + multiProjYawOffset + randomYawOffset;
            Vector3f upVector = new Vector3f();
            Vector3f direction = this.calculateDirection(this.pitch, this.yaw, totalPitchOffset, totalYawOffset, upVector);
            ((IDatapackProjectileEntity)en).setVectors(direction, upVector);
            en.m_6686_((double)direction.x, (double)direction.y, (double)direction.z, this.shootSpeed, 0.0f);
            if (this.fallDown) {
                en.m_20334_(0.0, -1.0, 0.0);
            }
            en.m_20225_(this.silent);
            this.caster.m_9236_().m_7967_((Entity)en);
        }
    }

    private double calculateRadius() {
        if (this.lifespanTicks == -1) {
            return 15.0;
        }
        return (float)this.lifespanTicks * this.shootSpeed;
    }

    @NotNull
    private Vector3f calculateDirection(float pitch, float yaw, float pitchOffset, float yawOffset, Vector3f outUpVector) {
        float pitchRad = (pitch + pitchOffset) * ((float)java.lang.Math.PI / 180);
        float yawRad = yaw * ((float)java.lang.Math.PI / 180);
        float yawOffsetRad = yawOffset * ((float)java.lang.Math.PI / 180);
        float cosPitch = Mth.m_14089_((float)pitchRad);
        float sinPitch = Mth.m_14031_((float)pitchRad);
        float cosYaw = Mth.m_14089_((float)yawRad);
        float sinYaw = Mth.m_14031_((float)yawRad);
        Vector3f forward = new Vector3f(-sinYaw * cosPitch, -sinPitch, cosYaw * cosPitch);
        outUpVector.set(-sinYaw * sinPitch, cosPitch, cosYaw * sinPitch);
        return forward.rotateAxis(-yawOffsetRad, outUpVector.x, outUpVector.y, outUpVector.z);
    }

    public static Vec3 positionToVelocity(MyPosition current, MyPosition destination) {
        return destination.m_82546_((Vec3)current).m_82541_();
    }

    public Vec3 getSideVelocity(Entity shooter) {
        float yaw = shooter.m_146908_() * ((float)java.lang.Math.PI / 180);
        return new Vec3((double)Math.cos((float)yaw), 0.0, (double)Math.sin((float)yaw));
    }

    public static enum CastType {
        SPREAD_OUT_IN_RADIUS,
        SPREAD_OUT_HORIZONTAL;

    }
}

