/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components;

import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SummonType;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.spells.SetAdd;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.AggroAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.ExileEffectAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.PositionSource;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SummonProjectileAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity.ParticleShape;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.value_calc.ValueCalculation;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AttackType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.DashUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class MapHolder {
    public String type;
    private HashMap<String, Object> map = new HashMap();

    public boolean has(MapField f) {
        return this.map.containsKey(f.GUID());
    }

    public <T> MapHolder put(MapField<T> field, T t) {
        if (field == MapField.VALUE_CALCULATION) {
            this.map.put(field.GUID(), ((ValueCalculation)t).GUID());
            return this;
        }
        this.map.put(field.GUID(), t);
        return this;
    }

    public <T> void modify(MapField<T> f, T def, Function<T, T> edit) {
        T val = this.getOrDefault(f, def);
        this.put(f, edit.apply(val));
    }

    public <T> T get(MapField<T> field) {
        if (field == MapField.VALUE_CALCULATION) {
            return (T)ExileDB.ValueCalculations().get((String)this.map.get(field.GUID()));
        }
        return (T)this.map.get(field.GUID());
    }

    public ExileEffect getExileEffect() {
        return (ExileEffect)ExileDB.ExileEffects().get(this.get(MapField.EXILE_POTION_ID));
    }

    public <T extends Enum> T getEnum(T en, MapField<String> f) {
        String o = this.get(f);
        return (T)Enum.valueOf(en.getClass(), o);
    }

    public AttackType getDmgEffectType() {
        return AttackType.valueOf(this.get(MapField.DMG_EFFECT_TYPE));
    }

    public MobEffect getPotion() {
        return (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(this.get(MapField.POTION_ID)));
    }

    public Elements getElement() {
        return Elements.valueOf(this.get(MapField.ELEMENT));
    }

    public SummonType getSummonType() {
        return SummonType.valueOf(this.get(MapField.SUMMON_TYPE));
    }

    public DashUtils.Way getPushWay() {
        return DashUtils.Way.valueOf(this.get(MapField.PUSH_WAY));
    }

    public AggroAction.Type getAggro() {
        return AggroAction.Type.valueOf(this.get(MapField.AGGRO_TYPE));
    }

    public ExileEffectAction.GiveOrTake getPotionAction() {
        return ExileEffectAction.GiveOrTake.valueOf(this.get(MapField.POTION_ACTION));
    }

    public SummonProjectileAction.ShootWay getOrDefault(SummonProjectileAction.ShootWay way) {
        String f = this.getOrDefault(MapField.SHOOT_DIRECTION, "");
        if (!f.isEmpty() && SummonProjectileAction.ShootWay.valueOf(f) != null) {
            return SummonProjectileAction.ShootWay.valueOf(f);
        }
        return way;
    }

    public PositionSource getOrDefault(PositionSource way) {
        String f = this.getOrDefault(MapField.POS_SOURCE, "");
        if (!f.isEmpty() && PositionSource.valueOf(f) != null) {
            return PositionSource.valueOf(f);
        }
        return way;
    }

    public Block getBlock() {
        return (Block)VanillaUTIL.REGISTRY.blocks().get(new ResourceLocation(this.get(MapField.BLOCK)));
    }

    public SoundEvent getSound() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(this.get(MapField.SOUND)));
    }

    public EntityFinder.SelectionType getSelectionType() {
        return EntityFinder.SelectionType.valueOf(this.get(MapField.SELECTION_TYPE));
    }

    public SetAdd getSetAdd() {
        return SetAdd.valueOf(this.get(MapField.SET_ADD));
    }

    public ParticleShape getParticleShape() {
        String str = this.get(MapField.PARTICLE_SHAPE);
        if (str != null && !str.isEmpty()) {
            return ParticleShape.valueOf(str);
        }
        return ParticleShape.CIRCLE;
    }

    public AllyOrEnemy getEntityPredicate() {
        return AllyOrEnemy.valueOf(this.get(MapField.ENTITY_PREDICATE));
    }

    public <T> T getOrDefault(MapField<T> field, T defa) {
        return (T)this.map.getOrDefault(field.GUID(), defa);
    }
}

