/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.profession;

import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.mine_and_slash.database.data.profession.Crafting_State;
import com.robertx22.mine_and_slash.database.data.profession.MergedContainer;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.data.profession.ProfessionBlock;
import com.robertx22.mine_and_slash.database.data.profession.ProfessionRecipe;
import com.robertx22.mine_and_slash.database.data.profession.all.Professions;
import com.robertx22.mine_and_slash.database.data.profession.screen.CraftingStationMenu;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.mmorpg.ModErrors;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashBlockEntities;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ISalvagable;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ProfessionBlockEntity
extends BlockEntity {
    public static MergedContainer.Inventory INPUTS = new MergedContainer.Inventory("INPUTS", 9, Direction.UP);
    public static MergedContainer.Inventory OUTPUTS = new MergedContainer.Inventory("OUTPUTS", 9, Direction.DOWN);
    public MergedContainer inventory = new MergedContainer(Arrays.asList(INPUTS, OUTPUTS), this);
    public SimpleContainer show = new SimpleContainer(1);
    public Boolean recipe_locked = false;
    public ProfessionRecipe last_recipe;
    public Crafting_State craftingState = Crafting_State.STOPPED;
    public UUID ownerUUID = null;
    int lastInputs = 0;

    public ProfessionBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)SlashBlockEntities.PROFESSION.get(), pPos, pBlockState);
    }

    public Profession getProfession() {
        String id = ((ProfessionBlock)this.m_58900_().m_60734_()).profession;
        return (Profession)ExileDB.Professions().get(id);
    }

    public Player getOwner(Level l) {
        if (this.ownerUUID != null) {
            return l.m_46003_(this.ownerUUID);
        }
        return null;
    }

    public void tryInputRecipe(ProfessionRecipe recipe, Player p) {
        if (!recipe.profession.equals(this.getProfession().GUID())) {
            return;
        }
        this.ownerUUID = p.m_20148_();
        this.recipe_locked = true;
        this.last_recipe = recipe;
    }

    public void tryTakeMaterialsFromNearbyChests() {
    }

    public List<Container> getNearbyInventories() {
        ArrayList<Container> list = new ArrayList<Container>();
        for (Direction dir : Arrays.asList(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST)) {
            BlockPos pos = this.m_58899_().m_121955_(dir.m_122436_());
            BlockEntity blockEntity = this.m_58904_().m_7702_(pos);
            if (!(blockEntity instanceof Container)) continue;
            Container inv = (Container)blockEntity;
            list.add(inv);
        }
        return list;
    }

    public boolean onTryInsertItem(ItemStack stack) {
        if (this.recipe_locked.booleanValue()) {
            this.craftingState = Crafting_State.ACTIVE;
        }
        return true;
    }

    public void onTickWhenPlayerWatching(Player p) {
        ProfessionRecipe recipe = this.getCurrentRecipe();
        if (recipe != null) {
            this.show.m_6836_(0, recipe.toResultStackForJei());
        } else {
            this.show.m_6836_(0, ItemStack.f_41583_);
        }
    }

    public void tick(Level level) {
        try {
            if (this.craftingState != Crafting_State.ACTIVE && this.craftingState == Crafting_State.IDLE) {
                SimpleContainer inv = this.inventory.getInventory(INPUTS);
                int inputs = 0;
                for (int i = 0; i < inv.m_6643_(); ++i) {
                    if (!inv.m_8020_(i).m_41619_()) continue;
                    ++inputs;
                }
                if (inputs != this.lastInputs) {
                    this.craftingState = Crafting_State.ACTIVE;
                    this.lastInputs = inputs;
                    this.tryTakeMaterialsFromNearbyChests();
                }
            }
            if (this.craftingState == Crafting_State.ACTIVE) {
                boolean ifOnlyDestroy = this.getMats().stream().filter(x -> !x.toString().equals(Blocks.f_50016_.m_5456_().m_7968_().toString())).allMatch(x -> x.toString().equals(((Item)SlashItems.DESTROY_OUTPUT.get()).m_7968_().toString()));
                if (this.inventory.getInventory(INPUTS).m_7983_() || ifOnlyDestroy) {
                    this.craftingState = this.recipe_locked != false ? Crafting_State.IDLE : Crafting_State.IDLE;
                    return;
                }
                Player p = this.getOwner(level);
                if (p != null && p.m_6084_()) {
                    if (this.getProfession().GUID().equals(Professions.SALVAGING)) {
                        ExplainedResult rec = this.trySalvage(p);
                        if (!rec.can && !this.recipe_locked.booleanValue()) {
                            this.show.m_6211_();
                        }
                    } else if (this.recipe_locked.booleanValue()) {
                        ExplainedResult can = this.last_recipe.canCraft(this.getMats());
                        if (can.can) {
                            ExplainedResult can2 = this.tryRecipe(p);
                            if (!can2.can && p.f_36096_ instanceof CraftingStationMenu) {
                                p.m_213846_(can2.answer);
                            }
                        } else if (p.f_36096_ instanceof CraftingStationMenu) {
                            p.m_213846_(can.answer);
                            this.craftingState = Crafting_State.IDLE;
                        }
                    } else {
                        ProfessionRecipe recipe = this.getCurrentRecipe();
                        if (recipe == null) {
                            p.m_213846_((Component)Chats.PROF_RECIPE_NOT_SELECTED.locName().m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                            this.craftingState = Crafting_State.IDLE;
                            return;
                        }
                        int ownerLvl = Load.player((Player)p).professions.getLevel(recipe.profession);
                        if (recipe.getLevelRequirement() > ownerLvl) {
                            p.m_213846_((Component)Chats.PROF_RECIPE_LEVEL_NOT_ENOUGH.locName(this.getProfession().locName(), recipe.getLevelRequirement(), ownerLvl).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                            this.craftingState = Crafting_State.IDLE;
                            return;
                        }
                        ExplainedResult can = recipe.canCraft(this.getMats());
                        if (can.can) {
                            ExplainedResult rec = this.tryRecipe(p);
                            if (!rec.can) {
                                this.show.m_6211_();
                                this.craftingState = Crafting_State.IDLE;
                            }
                        } else {
                            p.m_213846_(can.answer);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ModErrors.print(e);
        }
    }

    public boolean hasAtLeastOneFreeOutputSlot() {
        SimpleContainer inv = this.inventory.getInventory(OUTPUTS);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (!inv.m_8020_(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public ExplainedResult tryRecipe(Player p) {
        ProfessionRecipe recipe = this.recipe_locked != false ? this.last_recipe : this.getCurrentRecipe();
        if (recipe == null) {
            return ExplainedResult.failure((Component)Chats.PROF_RECIPE_NOT_SELECTED.locName());
        }
        int ownerLvl = Load.player((Player)p).professions.getLevel(this.getProfession().GUID());
        if (recipe.getLevelRequirement() > ownerLvl) {
            return ExplainedResult.failure((Component)Chats.PROF_RECIPE_LEVEL_NOT_ENOUGH.locName(this.getProfession().locName(), recipe.getLevelRequirement(), ownerLvl));
        }
        float expMulti = 1.0f;
        boolean destroyOuput = false;
        if (this.inventory.getInventory(INPUTS).m_18947_((Item)SlashItems.DESTROY_OUTPUT.get()) > 0 && !this.getProfession().GUID().equals(Professions.SALVAGING)) {
            expMulti = 2.0f;
            destroyOuput = true;
        }
        int expGive = (int)((float)recipe.getExpReward(p, ownerLvl, this.getMats()) * expMulti);
        this.addExp(expGive);
        List<ItemStack> output = recipe.craft(p, this.getMats());
        if (!destroyOuput && !this.tryPutToOutputs(output)) {
            return ExplainedResult.failure((Component)Chats.PROF_OUTPUT_SLOT_NOT_EMPTY.locName());
        }
        recipe.spendMaterials(this.getMats());
        this.m_6596_();
        return ExplainedResult.success();
    }

    public boolean tryPutToOutputs(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (this.inventory.addStack(OUTPUTS, stack)) continue;
            ItemEntity itementity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_(), stack);
            itementity.m_32060_();
            this.f_58857_.m_7967_((Entity)itementity);
        }
        return true;
    }

    public ExplainedResult trySalvage(Player p) {
        if (!this.hasAtLeastOneFreeOutputSlot()) {
            return ExplainedResult.failure((Component)Chats.PROF_OUTPUT_SLOT_NOT_EMPTY.locName());
        }
        int ownerLvl = Load.player((Player)p).professions.getLevel(this.getProfession().GUID());
        if (this.getProfession().GUID().equals(Professions.SALVAGING)) {
            for (ItemStack stack : this.getMats()) {
                ExileStack ex = ExileStack.of(stack);
                ICommonDataItem data = ICommonDataItem.load(stack);
                ISalvagable sal = ISalvagable.load(stack);
                if (data != null && sal != null && sal.isSalvagable(ex)) {
                    float multi = data.getRarity().item_value_multi;
                    ArrayList<ItemStack> output = new ArrayList<ItemStack>();
                    output.addAll(sal.getSalvageResult(ex));
                    for (float extraSalvageChance = (float)ownerLvl * 0.01f; extraSalvageChance > 0.0f; extraSalvageChance -= 1.0f) {
                        if (!(extraSalvageChance >= 1.0f) && !(p.m_9236_().f_46441_.m_188501_() < extraSalvageChance)) continue;
                        output.addAll(sal.getSalvageResult(ex));
                    }
                    output.addAll(this.getProfession().getAllDrops(p, ownerLvl, data.getLevel(), multi));
                    this.tryPutToOutputs(output);
                    this.addExp(data.getSalvageExpReward());
                    stack.m_41774_(1);
                    this.m_6596_();
                    return ExplainedResult.success();
                }
                if (stack == null || stack.m_41619_()) continue;
                ItemStack copy = stack.m_41777_();
                stack.m_41774_(stack.m_41613_());
                ItemEntity itementity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_() + 1.5, (double)this.m_58899_().m_123343_(), copy);
                itementity.m_32060_();
                this.f_58857_.m_7967_((Entity)itementity);
                p.m_213846_((Component)Words.UNSALVAGEABLE.locName().m_130946_(": ").m_7220_(copy.m_41611_()));
            }
        }
        return ExplainedResult.failure((Component)Component.m_237113_((String)""));
    }

    public void addExp(int xp) {
        Player p = this.getOwner(this.f_58857_);
        if (p != null) {
            Load.player((Player)p).professions.addExp(p, this.getProfession().GUID(), xp);
        }
    }

    public List<ItemStack> getMats() {
        return this.inventory.getAllStacks(INPUTS);
    }

    public ProfessionRecipe getCurrentRecipe() {
        if (this.recipe_locked.booleanValue() && this.last_recipe != null) {
            return this.last_recipe;
        }
        return null;
    }

    public ListTag createTag() {
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag slot = new CompoundTag();
            slot.m_128405_("slot", i);
            itemstack.m_41739_(slot);
            listtag.add((Object)slot);
        }
        return listtag;
    }

    public void fromTag(ListTag pContainerNbt) {
        this.inventory.m_6211_();
        for (int i = 0; i < pContainerNbt.size(); ++i) {
            CompoundTag tag = pContainerNbt.m_128728_(i);
            int slot = tag.m_128451_("slot");
            tag.m_128473_("slot");
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)tag);
            this.inventory.m_6836_(slot, itemstack);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        try {
            this.fromTag(pTag.m_128437_("inv", 10));
            this.show.m_7797_(pTag.m_128437_("show", 10));
            this.recipe_locked = pTag.m_128471_("locked");
            String state = pTag.m_128461_("state");
            if (state.isEmpty()) {
                state = Crafting_State.IDLE.name();
            }
            this.craftingState = Crafting_State.valueOf(state);
            if (this.craftingState != Crafting_State.STOPPED) {
                if (pTag.m_128441_("owner")) {
                    this.ownerUUID = pTag.m_128342_("owner");
                } else {
                    this.ownerUUID = null;
                    this.craftingState = Crafting_State.STOPPED;
                }
            }
            if (this.recipe_locked.booleanValue() && pTag.m_128441_("recipe")) {
                this.last_recipe = (ProfessionRecipe)ExileDB.Recipes().get(pTag.m_128461_("recipe"));
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        try {
            pTag.m_128365_("inv", (Tag)this.createTag());
            pTag.m_128365_("show", (Tag)this.show.m_7927_());
            if (this.recipe_locked.booleanValue()) {
                if (this.last_recipe != null) {
                    pTag.m_128379_("locked", this.recipe_locked.booleanValue());
                    pTag.m_128359_("recipe", this.last_recipe.GUID());
                } else {
                    pTag.m_128379_("locked", false);
                }
            }
            if (this.craftingState != Crafting_State.STOPPED) {
                if (this.ownerUUID != null) {
                    pTag.m_128362_("owner", this.ownerUUID);
                    pTag.m_128359_("state", this.craftingState.name());
                } else {
                    pTag.m_128359_("state", Crafting_State.STOPPED.name());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ int lambda$getCurrentRecipe$4(ProfessionRecipe x) {
        return x.tier;
    }

    private static /* synthetic */ boolean lambda$getCurrentRecipe$3(String prof, List mats, ProfessionRecipe x) {
        return x.profession.equals(prof) && x.canCraft((List<ItemStack>)mats).can;
    }

    private static /* synthetic */ boolean lambda$getCurrentRecipe$2(ItemStack x) {
        return !x.m_41619_();
    }
}

