/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.profession;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.Weighted;
import com.robertx22.mine_and_slash.database.data.profession.ExpSources;
import com.robertx22.mine_and_slash.database.data.profession.ProfessionRecipe;
import com.robertx22.mine_and_slash.database.data.profession.stat.DoubleDropChance;
import com.robertx22.mine_and_slash.database.data.profession.stat.ProfCategoryDropStat;
import com.robertx22.mine_and_slash.database.data.profession.stat.TripleDropChance;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.LootChestBlueprint;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.temp.SkillItemTier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class Profession
implements JsonExileRegistry<Profession>,
IAutoGson<Profession>,
IAutoLocName,
IAutoLocDesc {
    public static Profession SERIALIZER = new Profession();
    public String id = "";
    public transient String locname = "";
    public transient String desc = "";
    public String tool_tag = "";
    public float misc_chance = 5.0f;
    public ExpSources exp_sources = new ExpSources();
    public HashMap<SkillItemTier, List<ChancedDrop>> tiered_drops = new HashMap();
    public List<ChancedDrop> chance_drops = new ArrayList<ChancedDrop>();

    public ItemStack randomFishingLootCrate(int lvl) {
        LootChestBlueprint b = new LootChestBlueprint(LootInfo.ofLevel(lvl));
        b.useRarityKey = true;
        return b.createStack();
    }

    public List<ItemStack> getAllDrops(Player p, int lvl, int recipelvl, float dropChanceMulti) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ProfessionRecipe.RecipeDifficulty diff = ProfessionRecipe.RecipeDifficulty.get(lvl, recipelvl);
        float lvlmulti = LevelUtils.getMaxLevelMultiplier(lvl);
        SkillItemTier tier = SkillItemTier.fromLevel(lvl);
        ArrayList<ChancedDrop> ALLDROPS = new ArrayList<ChancedDrop>();
        if (this.tiered_drops.containsKey((Object)tier)) {
            ALLDROPS.addAll((Collection)this.tiered_drops.get((Object)tier));
        }
        ALLDROPS.addAll(this.chance_drops);
        for (ChancedDrop chancedDrop : ALLDROPS) {
            Weighted drop;
            float statMuti = Load.Unit((Entity)p).getUnit().getCalculatedStat(new ProfCategoryDropStat(chancedDrop.type, this.GUID())).getMultiplier();
            float chance = dropChanceMulti * chancedDrop.chance * statMuti;
            if (!RandomUtils.roll((float)chance) || (drop = (Weighted)RandomUtils.weightedRandom((Collection)chancedDrop.drops.stream().filter(x -> lvlmulti >= x.min_lvl).map(x -> x.toWeighted(p, this)).collect(Collectors.toList()))) == null) continue;
            ItemStack stack = ((ProfessionDrop)drop.obj).get();
            list.add(stack);
        }
        float doubleDrop = (float)diff.doubleDropChance + Load.Unit((Entity)p).getUnit().getCalculatedStat(new DoubleDropChance(this.GUID())).getValue();
        float tripleDrop = Load.Unit((Entity)p).getUnit().getCalculatedStat(new TripleDropChance(this.GUID())).getValue();
        if (RandomUtils.roll((float)doubleDrop)) {
            for (ItemStack stack : list) {
                stack.m_41764_(MathHelper.clamp(stack.m_41613_() * 2, 1, stack.m_41741_()));
            }
        }
        if (RandomUtils.roll((float)tripleDrop)) {
            for (ItemStack stack : list) {
                stack.m_41764_(MathHelper.clamp(stack.m_41613_() * 3, 1, stack.m_41741_()));
            }
        }
        return list;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locDescGroup() {
        return IBaseAutoLoc.AutoLocGroup.Misc;
    }

    @Override
    public String locDescLangFileGUID() {
        return "mmorpg.profession.desc." + this.GUID();
    }

    @Override
    public String locDescForLangFile() {
        return this.desc;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Misc;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.profession." + this.GUID();
    }

    @Override
    public String locNameForLangFile() {
        return this.locname;
    }

    public List<ItemStack> onFish(Player p) {
        int lvl = Load.player((Player)p).professions.getLevel(this.GUID());
        SkillItemTier tier = SkillItemTier.fromLevel(lvl);
        ExpSources.ExpData data = this.exp_sources.exp(250, tier.tier);
        if (data.exp > 0) {
            data.giveExp(p, this);
            float chance = data.getLootChanceMulti(p, this);
            List<ItemStack> list = this.getAllDrops(p, Load.player((Player)p).professions.getLevel(this.GUID()), data.getLevelOfMastery(), chance);
            if (RandomUtils.roll((float)this.misc_chance)) {
                list.add(this.randomFishingLootCrate(lvl));
            }
            return list;
        }
        return Arrays.asList(new ItemStack[0]);
    }

    public List<ItemStack> onBreedAnimal(Player p, Entity en) {
        ExpSources.ExpData data = this.exp_sources.getData(en.m_6095_());
        if (data == null || data.exp == 0) {
            data = this.exp_sources.getDefaultExp();
        }
        if (data.exp > 0) {
            data.giveExp(p, this);
            float chance = data.getLootChanceMulti(p, this);
            return this.getAllDrops(p, Load.player((Player)p).professions.getLevel(this.GUID()), data.getLevelOfMastery(), chance);
        }
        return Arrays.asList(new ItemStack[0]);
    }

    public List<ItemStack> onMineGetBonusDrops(Player p, List<ItemStack> drops, BlockState state) {
        ExpSources.ExpData data = this.exp_sources.getData(state.m_60734_());
        if (data == null) {
            for (TagKey tagKey : state.m_204343_().toList()) {
                if (this.exp_sources.getData(tagKey) == null) continue;
                data = this.exp_sources.getData(tagKey);
                break;
            }
        }
        if (data == null) {
            for (ItemStack itemStack : drops) {
                if (this.exp_sources.getData(itemStack.m_41720_()) == null) continue;
                data = this.exp_sources.getData(itemStack.m_41720_());
                break;
            }
        }
        if (data != null && data.exp > 0) {
            if (data.req.contains(ExpSources.REQ_GROWTH_STAGE)) {
                Optional opt = state.m_61145_((Property)CropBlock.f_52244_);
                if (!opt.isPresent()) {
                    ExileLog.get().log(BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).toString() + " requires growth stage but doesn't have the age value!", new Object[0]);
                    return Arrays.asList(new ItemStack[0]);
                }
                if ((Integer)opt.get() != 7) {
                    return Arrays.asList(new ItemStack[0]);
                }
            }
            data.giveExp(p, this);
            float chance = data.getLootChanceMulti(p, this);
            return this.getAllDrops(p, Load.player((Player)p).professions.getLevel(this.GUID()), data.getLevelOfMastery(), chance);
        }
        return Arrays.asList(new ItemStack[0]);
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.PROFESSION;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return 1000;
    }

    public Class<Profession> getClassForSerialization() {
        return Profession.class;
    }

    public static class ChancedDrop {
        public List<ProfessionDrop> drops = new ArrayList<ProfessionDrop>();
        public DropCategory type;
        public float chance = 0.0f;

        public ChancedDrop(List<ProfessionDrop> drops, DropCategory type, float chance) {
            this.drops = drops;
            this.type = type;
            this.chance = chance;
        }
    }

    public static enum DropCategory {
        MAIN("core", "Core");

        public String id;
        public String locname;

        private DropCategory(String id, String locname) {
            this.id = id;
            this.locname = locname;
        }
    }

    public static class ProfessionDrop {
        public String item_id = "";
        public int num = 1;
        private int weight = 1000;
        public float min_lvl = 0.0f;

        public ProfessionDrop(String item_id, int num, int weight, float min_lvl) {
            this.item_id = item_id;
            this.num = num;
            this.weight = weight;
            this.min_lvl = min_lvl;
        }

        public ItemStack get() {
            return new ItemStack((ItemLike)VanillaUTIL.REGISTRY.items().get(new ResourceLocation(this.item_id)), this.num);
        }

        private int getWeight(Player p, Profession pro) {
            return this.weight;
        }

        public Weighted<ProfessionDrop> toWeighted(Player p, Profession pro) {
            return new Weighted<ProfessionDrop>(this, this.getWeight(p, pro));
        }
    }

    public static enum Type {
        BLOCK,
        ENTITY,
        OTHER;

    }
}

