/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.omen;

import com.robertx22.library_of_exile.util.UNICODE;
import com.robertx22.mine_and_slash.database.data.omen.OmenData;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.AffixData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class OmenSet {
    public HashMap<Integer, List<ExactStatData>> stats = new HashMap();
    OmenData data;

    public OmenSet(OmenData data) {
        this.data = data;
        int max = 0;
        for (Integer num : data.rarities.values()) {
            max += num.intValue();
        }
        int index = max;
        int perc = OmenData.getStatPercent(data.rarities, data.slot_req, data.getRarity());
        if (!this.stats.containsKey(index)) {
            this.stats.put(index, new ArrayList());
        }
        this.stats.get(index).addAll(data.getOmen().mods.stream().map(x -> x.ToExactStat(perc, data.lvl)).collect(Collectors.toList()));
        --index;
        for (AffixData affix : data.aff) {
            this.stats.put(index, affix.GetAllStats(data.lvl));
            if (--index >= 2) continue;
            index = 2;
        }
    }

    public List<ExactStatData> getStats(Player p) {
        ArrayList<ExactStatData> all = new ArrayList<ExactStatData>();
        int fill = Load.player((Player)p).omensFilled;
        for (Map.Entry<Integer, List<ExactStatData>> en : this.stats.entrySet()) {
            if (fill < en.getKey()) continue;
            for (ExactStatData stat : en.getValue()) {
                all.add(stat);
            }
        }
        return all;
    }

    public List<MutableComponent> getTooltip(Player p) {
        ArrayList<MutableComponent> all = new ArrayList<MutableComponent>();
        int fill = Load.player((Player)p).omensFilled;
        for (Map.Entry<Integer, List<ExactStatData>> en : this.stats.entrySet()) {
            ChatFormatting color = fill >= en.getKey() ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.GRAY;
            all.add(Component.m_237113_((String)(UNICODE.STAR + " ")).m_7220_((Component)Itemtips.OMEN_SET_PIECES.locName(en.getKey())).m_130940_(color));
            for (ExactStatData stat : en.getValue()) {
                all.addAll(stat.GetTooltipString().stream().map(x -> x.m_130940_(ChatFormatting.GRAY)).collect(Collectors.toList()));
            }
        }
        return all;
    }
}

