/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.omen;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.omen.OmenData;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarityType;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class Omen
implements JsonExileRegistry<Omen>,
IAutoGson<Omen>,
IAutoLocName {
    public static Omen SERIALIZER = new Omen("ser", "ser", 0.0f, Arrays.asList(new StatMod[0]));
    public String id = "";
    public int weight = 1000;
    public transient String locname = "";
    public float lvl_req = 0.0f;
    public List<StatMod> mods = new ArrayList<StatMod>();
    public List<Affix.AffixSlot> affix_types = new ArrayList<Affix.AffixSlot>(Arrays.asList(Affix.AffixSlot.chaos_stat, Affix.AffixSlot.jewel_corruption));

    public Omen(String id, String locname, float lvl_req, List<StatMod> mods) {
        this.id = id;
        this.locname = locname;
        this.lvl_req = lvl_req;
        this.mods = mods;
    }

    public Omen addCorruptionAffixes() {
        this.affix_types.add(Affix.AffixSlot.chaos_stat);
        return this;
    }

    public GearSlot getRandomSlotReq() {
        return (GearSlot)ExileDB.GearSlots().getFilterWrapped(x -> !x.fam.isWeapon()).random();
    }

    public GearRarityType getRandomSlotReqRarity(OmenData data) {
        return Arrays.stream(GearRarityType.values()).max(Comparator.comparingInt(x -> -((int)data.slot_req.stream().filter(s -> s.rtype == x).count()))).orElse(GearRarityType.NORMAL);
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.OMEN;
    }

    public Class<Omen> getClassForSerialization() {
        return Omen.class;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return this.weight;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Omens;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.omen." + this.GUID();
    }

    @Override
    public String locNameForLangFile() {
        return this.locname;
    }
}

