/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.level_ranges;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.uncommon.MathHelper;

public class LevelRange {
    public static LevelRange SERIALIZER = new LevelRange(0.0f, 0.0f);
    private float start;
    private float end;
    public transient String id_suffix;

    public LevelRange(String id_suffix, float start, float end) {
        this.start = start;
        this.end = end;
        this.id_suffix = id_suffix;
    }

    private LevelRange(float start, float end) {
        this.start = start;
        this.end = end;
    }

    public int getMiddleLevel() {
        return (this.getMinLevel() + this.getMaxLevel()) / 2;
    }

    public int randomFromRange() {
        return RandomUtils.RandomRange((int)this.getMinLevel(), (int)this.getMaxLevel());
    }

    public int getMinLevel() {
        return MathHelper.clamp((int)(this.start * (float)GameBalanceConfig.get().MAX_LEVEL), 1, GameBalanceConfig.get().MAX_LEVEL);
    }

    public int getMaxLevel() {
        return (int)(this.end * (float)GameBalanceConfig.get().MAX_LEVEL);
    }

    public float getEndPercent() {
        return this.end;
    }

    public float getStartPercent() {
        return this.start;
    }

    public boolean isLevelInRange(int lvl) {
        return lvl >= this.getMinLevel() && lvl <= this.getMaxLevel();
    }
}

