/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.gear_types.bases;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.IWeighted;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.SlotFamily;
import com.robertx22.mine_and_slash.database.data.gear_types.weapons.mechanics.NormalWeaponMechanic;
import com.robertx22.mine_and_slash.database.data.gear_types.weapons.mechanics.WeaponMechanic;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRequirement;
import com.robertx22.mine_and_slash.tags.ModTag;
import com.robertx22.mine_and_slash.tags.TagList;
import com.robertx22.mine_and_slash.tags.all.SlotTags;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.enumclasses.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public final class BaseGearType
implements IAutoLocName,
JsonExileRegistry<BaseGearType>,
IAutoGson<BaseGearType> {
    public static BaseGearType SERIALIZER = new BaseGearType();
    protected String guid;
    public String gear_slot = "";
    public int weight = 1000;
    public PlayStyle style = PlayStyle.STR;
    public StatRequirement req = new StatRequirement();
    public List<StatMod> base_stats = new ArrayList<StatMod>();
    public String weapon_type;
    public TagList tags;
    public List<ItemChance> possible_items;
    protected transient String locname;

    public BaseGearType(String slot, String guid, String locname) {
        this.weapon_type = WeaponTypes.none.id;
        this.tags = new TagList(new ModTag[0]);
        this.possible_items = new ArrayList<ItemChance>();
        this.guid = guid;
        this.locname = locname;
        this.gear_slot = slot;
    }

    private BaseGearType() {
        this.weapon_type = WeaponTypes.none.id;
        this.tags = new TagList(new ModTag[0]);
        this.possible_items = new ArrayList<ItemChance>();
    }

    public List<StatMod> baseStats() {
        return this.base_stats;
    }

    public WeaponTypes weaponType() {
        return (WeaponTypes)ExileDB.WeaponTypes().get(this.weapon_type);
    }

    public TagList getTags() {
        return this.tags;
    }

    public final String GUID() {
        return this.guid;
    }

    public GearSlot getGearSlot() {
        return (GearSlot)ExileDB.GearSlots().get(this.gear_slot);
    }

    public Item getRandomItem(GearRarity rar) {
        List list = this.possible_items.stream().filter(x -> rar.item_tier >= ((GearRarity)ExileDB.GearRarities().get((String)x.min_rar)).item_tier).collect(Collectors.toList());
        if (list.isEmpty()) {
            return Items.f_41852_;
        }
        return ((ItemChance)RandomUtils.weightedRandom(list)).getItem();
    }

    @Override
    public final String locNameForLangFile() {
        return this.locname;
    }

    public final EquipmentSlot getVanillaSlotType() {
        if (this.tags.contains(SlotTags.shield)) {
            return EquipmentSlot.OFFHAND;
        }
        if (this.tags.contains(SlotTags.boots)) {
            return EquipmentSlot.FEET;
        }
        if (this.tags.contains(SlotTags.chest)) {
            return EquipmentSlot.CHEST;
        }
        if (this.tags.contains(SlotTags.pants)) {
            return EquipmentSlot.LEGS;
        }
        if (this.tags.contains(SlotTags.helmet)) {
            return EquipmentSlot.HEAD;
        }
        if (this.isWeapon()) {
            return EquipmentSlot.MAINHAND;
        }
        return null;
    }

    public int Weight() {
        return this.weight;
    }

    public final boolean isArmor() {
        return this.family() == SlotFamily.Armor;
    }

    public final boolean isJewelry() {
        return this.family() == SlotFamily.Jewelry;
    }

    public final boolean isWeapon() {
        return this.family() == SlotFamily.Weapon;
    }

    public final boolean isOffhand() {
        return this.family() == SlotFamily.OffHand;
    }

    public final boolean isMeleeWeapon() {
        return this.getTags().contains(SlotTags.melee_weapon);
    }

    public boolean isShield() {
        return this.getTags().contains(SlotTags.shield);
    }

    public final SlotFamily family() {
        return this.getGearSlot().fam;
    }

    public final WeaponMechanic getWeaponMechanic() {
        return new NormalWeaponMechanic();
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.GEAR_TYPE;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Gear_Slots;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.gear_type." + this.GUID();
    }

    public final boolean isMageWeapon() {
        return this.getTags().contains(SlotTags.mage_weapon);
    }

    public Class<BaseGearType> getClassForSerialization() {
        return BaseGearType.class;
    }

    public static class ItemChance
    implements IWeighted {
        public int weight = 1000;
        public String item_id = "";
        public String min_rar = "common";

        public ItemChance(int weight, String item_id, String min_rar) {
            this.weight = weight;
            this.item_id = item_id;
            this.min_rar = min_rar;
        }

        public Item getItem() {
            return (Item)VanillaUTIL.REGISTRY.items().get(new ResourceLocation(this.item_id));
        }

        public int Weight() {
            return this.weight;
        }
    }
}

