/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.game_balance_config;

import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsConfig;
import com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellSchoolsData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PlayerPointsType implements IGUID
{
    TALENTS{

        public String GUID() {
            return "talent";
        }

        @Override
        public Words word() {
            return Words.Talents;
        }

        @Override
        public Item matItem() {
            return Items.f_42415_;
        }

        @Override
        public int getPointsInUse(Player p) {
            return Load.player((Player)p).talents.getAllocatedPoints(TalentTree.SchoolType.TALENTS);
        }

        @Override
        public void fullReset(Player p) {
            Load.player((Player)p).talents.clearAllTalents(TalentTree.SchoolType.TALENTS);
        }
    }
    ,
    SPELLS{

        public String GUID() {
            return "spell";
        }

        @Override
        public Words word() {
            return Words.SPELL;
        }

        @Override
        public Item matItem() {
            return Items.f_41997_;
        }

        @Override
        public int getPointsInUse(Player p) {
            return Load.player((Player)p).ascClass.getSpentPoints(SpellSchoolsData.PointType.SPELL);
        }

        @Override
        public void fullReset(Player p) {
            Load.player((Player)p).ascClass.reset(SpellSchoolsData.PointType.SPELL, p);
        }
    }
    ,
    PASSIVES{

        public String GUID() {
            return "passive";
        }

        @Override
        public Words word() {
            return Words.Passive;
        }

        @Override
        public Item matItem() {
            return Items.f_42616_;
        }

        @Override
        public int getPointsInUse(Player p) {
            return Load.player((Player)p).ascClass.getSpentPoints(SpellSchoolsData.PointType.PASSIVE);
        }

        @Override
        public void fullReset(Player p) {
            Load.player((Player)p).ascClass.reset(SpellSchoolsData.PointType.PASSIVE, p);
        }
    }
    ,
    ASCENDANCY{

        public String GUID() {
            return "ascendancy";
        }

        @Override
        public Words word() {
            return Words.AscClasses;
        }

        @Override
        public Item matItem() {
            return Items.f_42436_;
        }

        @Override
        public int getPointsInUse(Player p) {
            return Load.player((Player)p).talents.getAllocatedPoints(TalentTree.SchoolType.ASCENDANCY);
        }

        @Override
        public void fullReset(Player p) {
            Load.player((Player)p).talents.clearAllTalents(TalentTree.SchoolType.ASCENDANCY);
        }
    }
    ,
    STATS{

        public String GUID() {
            return "stat";
        }

        @Override
        public Words word() {
            return Words.Stat;
        }

        @Override
        public Item matItem() {
            return Items.f_42410_;
        }

        @Override
        public int getPointsInUse(Player p) {
            return Load.player((Player)p).statPoints.getAllocatedPoints();
        }

        @Override
        public void fullReset(Player p) {
            Load.player((Player)p).statPoints.reset();
        }
    };


    public abstract Words word();

    private final int getBonusPoints(Player p) {
        PlayerPointsConfig data = this.getConfig();
        int c = Load.player((Player)p).points.get(this).getBonusPoints();
        if (this == TALENTS) {
            c += Load.player((Player)p).bonusTalents;
        }
        if (c > data.max_bonus_points) {
            c = data.max_bonus_points;
        }
        return c;
    }

    public abstract Item matItem();

    public abstract int getPointsInUse(Player var1);

    public PlayerPointsConfig getConfig() {
        return GameBalanceConfig.get().player_points.get((Object)this);
    }

    public boolean hasFreePoints(Player p) {
        return this.getFreePoints(p) > 0;
    }

    public boolean hasResetPoints(Player p) {
        return this.getResetPoints(p) > 0;
    }

    public void reduceResetPoints(Player p, int spent) {
        Load.player((Player)p).points.get((PlayerPointsType)this).reset_points -= spent;
    }

    public void addResetPoints(Player p, int spent) {
        Load.player((Player)p).points.get((PlayerPointsType)this).reset_points += spent;
    }

    public abstract void fullReset(Player var1);

    public int getResetPoints(Player p) {
        return Load.player((Player)p).points.get((PlayerPointsType)this).reset_points;
    }

    public int getFreePoints(Player p) {
        int bonus;
        PlayerPointsConfig data = this.getConfig();
        int lvl = Load.Unit((Entity)p).getLevel();
        int current = data.base_points + (int)((float)lvl * data.points_per_lvl);
        int total = current + (bonus = this.getBonusPoints(p));
        if (total > data.max_total_points) {
            total = data.max_total_points;
        }
        int spent = this.getPointsInUse(p);
        int free = (total += Load.player((Player)p).points.get(this).getBonusCheatPoints()) - spent;
        return free;
    }
}

