/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.game_balance_config;

import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.capability.player.data.Backpacks;
import com.robertx22.mine_and_slash.config.forge.compat.CompatConfig;
import com.robertx22.mine_and_slash.database.data.game_balance_config.BackpackTabConfig;
import com.robertx22.mine_and_slash.database.data.game_balance_config.LevelScalingConfig;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsConfig;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsType;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.HashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class GameBalanceConfig
implements JsonExileRegistry<GameBalanceConfig>,
IAutoGson<GameBalanceConfig> {
    public static GameBalanceConfig SERIALIZER = new GameBalanceConfig();
    public String id;
    public int MAX_LEVEL;
    public LevelScalingConfig NORMAL_STAT_SCALING;
    public LevelScalingConfig SLOW_STAT_SCALING;
    public LevelScalingConfig MANA_COST_SCALING;
    public LevelScalingConfig CORE_STAT_SCALING;
    public LevelScalingConfig STAT_REQ_SCALING;
    public LevelScalingConfig MOB_DAMAGE_SCALING;
    public HashMap<PlayerPointsType, PlayerPointsConfig> player_points;
    public HashMap<Backpacks.BackpackType, BackpackTabConfig> backpack_tabs;
    public double MOB_DMG_MULTI_PER_MAP_RES_REQ_LACKING;
    public double HP_MOB_BONUS_PER_MAP_TIER;
    public double DMG_MOB_BONUS_PER_MAP_TIER;
    public double MIN_SPELL_COOLDOWN_MULTI;
    public int GLOBAL_COOLDOWN_TICKS;
    public double CRAFTED_GEAR_POTENTIAL_MULTI;
    public int MAX_BONUS_SPELL_LEVELS;
    public double MOB_HP_POWER_SCALING;
    public double MOB_DMG_POWER_SCALING;
    public double MOB_DMG_POWER_SCALING_BASE;
    public double MOB_HP_POWER_SCALING_BASE;
    public double PROFESSION_EXP_PENALTY_PER_LOWER_LEVEL;
    public int link_1_lvl;
    public int link_2_lvl;
    public int link_3_lvl;
    public int link_4_lvl;
    public int link_5_lvl;
    public float DMG_REDUCT_PER_CHAIN;
    public float MIN_CHAIN_DMG;

    public GameBalanceConfig() {
        this.id = BalanceEnum.ORIGINAL_BALANCE.id;
        this.MAX_LEVEL = 100;
        this.NORMAL_STAT_SCALING = new LevelScalingConfig(1.0f, 0.2f, false);
        this.SLOW_STAT_SCALING = new LevelScalingConfig(1.0f, 0.01f, true);
        this.MANA_COST_SCALING = new LevelScalingConfig(1.0f, 0.2f, true);
        this.CORE_STAT_SCALING = new LevelScalingConfig(1.0f, 0.05f, true);
        this.STAT_REQ_SCALING = new LevelScalingConfig(2.0f, 2.0f, true);
        this.MOB_DAMAGE_SCALING = new LevelScalingConfig(1.0f, 0.25f, false);
        this.player_points = new HashMap();
        this.backpack_tabs = new HashMap();
        this.MOB_DMG_MULTI_PER_MAP_RES_REQ_LACKING = 0.05;
        this.HP_MOB_BONUS_PER_MAP_TIER = 0.1;
        this.DMG_MOB_BONUS_PER_MAP_TIER = 0.01;
        this.MIN_SPELL_COOLDOWN_MULTI = 0.2;
        this.GLOBAL_COOLDOWN_TICKS = 3;
        this.CRAFTED_GEAR_POTENTIAL_MULTI = 0.5;
        this.MAX_BONUS_SPELL_LEVELS = 5;
        this.MOB_HP_POWER_SCALING = 1.003;
        this.MOB_DMG_POWER_SCALING = 1.003;
        this.MOB_DMG_POWER_SCALING_BASE = 1.0;
        this.MOB_HP_POWER_SCALING_BASE = 1.0;
        this.PROFESSION_EXP_PENALTY_PER_LOWER_LEVEL = 0.2;
        this.link_1_lvl = 1;
        this.link_2_lvl = 5;
        this.link_3_lvl = 10;
        this.link_4_lvl = 25;
        this.link_5_lvl = 50;
        this.DMG_REDUCT_PER_CHAIN = 0.2f;
        this.MIN_CHAIN_DMG = 0.2f;
    }

    public static GameBalanceConfig get() {
        ExileRegistryContainer reg = Database.getRegistry((ExileRegistryType)ExileRegistryTypes.GAME_BALANCE);
        String id = CompatConfig.get().balanceDatapack().id;
        return (GameBalanceConfig)reg.get(id);
    }

    public void editForCompat() {
        this.NORMAL_STAT_SCALING = new LevelScalingConfig(1.0f, 0.02f, false);
        this.SLOW_STAT_SCALING = new LevelScalingConfig(1.0f, 0.01f, true);
        this.MANA_COST_SCALING = new LevelScalingConfig(1.0f, 0.0f, true);
        this.CORE_STAT_SCALING = new LevelScalingConfig(1.0f, 0.005f, true);
        this.STAT_REQ_SCALING = new LevelScalingConfig(2.0f, 0.2f, true);
        this.MOB_DAMAGE_SCALING = new LevelScalingConfig(1.0f, 0.025f, false);
        this.MOB_HP_POWER_SCALING = 1.0;
        this.MOB_DMG_POWER_SCALING = 1.0;
        this.MOB_DMG_MULTI_PER_MAP_RES_REQ_LACKING = 1.0;
        this.player_points.put(PlayerPointsType.STATS, new PlayerPointsConfig(PlayerPointsType.STATS, 0, 0.2f, 25, 200));
    }

    public int getMaxLinksForLevel(int lvl) {
        if (lvl < this.link_1_lvl) {
            return 0;
        }
        if (lvl < this.link_2_lvl) {
            return 1;
        }
        if (lvl < this.link_3_lvl) {
            return 2;
        }
        if (lvl < this.link_4_lvl) {
            return 3;
        }
        if (lvl < this.link_5_lvl) {
            return 4;
        }
        return 5;
    }

    public int getNextLinkUpgradeLevel(int lvl) {
        if (lvl < this.link_1_lvl) {
            return this.link_1_lvl;
        }
        if (lvl < this.link_2_lvl) {
            return this.link_2_lvl;
        }
        if (lvl < this.link_3_lvl) {
            return this.link_3_lvl;
        }
        if (lvl < this.link_4_lvl) {
            return this.link_4_lvl;
        }
        if (lvl < this.link_5_lvl) {
            return this.link_5_lvl;
        }
        return 5;
    }

    public int getTotalLinks(int links, Player p) {
        int max = this.getMaxLinksForLevel(Load.Unit((Entity)p).getLevel());
        return MathHelper.clamp(links, 0, max);
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.GAME_BALANCE;
    }

    public String GUID() {
        return this.id;
    }

    public Class<GameBalanceConfig> getClassForSerialization() {
        return GameBalanceConfig.class;
    }

    public int Weight() {
        return 1000;
    }

    public static enum BalanceEnum {
        ORIGINAL_BALANCE("original_balance"),
        COMPAT_BALANCE("compat_mode_balance");

        public String id;

        private BalanceEnum(String id) {
            this.id = id;
        }
    }
}

