/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.aura;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.aura.AuraGems;
import com.robertx22.mine_and_slash.database.data.support_gem.SupportGem;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.ISkillGem;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.SkillGemData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AuraGem
implements JsonExileRegistry<SupportGem>,
ISkillGem,
IAutoGson<AuraGem> {
    public static AuraGem SERIALIZER = new AuraGem(AuraGems.summon_dmg, PlayStyle.STR, 0.0f, Arrays.asList(new StatMod[0]));
    public String id = "";
    public int min_lvl = 1;
    public PlayStyle style = PlayStyle.INT;
    public float reservation = 0.25f;
    public List<StatMod> stats = new ArrayList<StatMod>();
    transient String name;

    public AuraGem(AuraGems.AuraInfo info, PlayStyle style, float reservation, List<StatMod> stats) {
        this.id = info.id;
        this.name = info.name + " Augment";
        this.style = style;
        this.reservation = reservation;
        this.stats = stats;
    }

    public AuraGem levelReq(int lvl) {
        this.min_lvl = lvl;
        return this;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.AURA;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return 1000;
    }

    @Override
    public int getRequiredLevel() {
        return this.min_lvl;
    }

    @Override
    public PlayStyle getStyle() {
        return this.style;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Spells;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.aura." + this.GUID();
    }

    @Override
    public String locNameForLangFile() {
        return this.name;
    }

    public List<ExactStatData> GetAllStats(EntityData en, SkillGemData data) {
        return this.stats.stream().map(x -> x.ToExactStat(data.getStatPercent(), en.getLevel())).collect(Collectors.toList());
    }

    public Class<AuraGem> getClassForSerialization() {
        return AuraGem.class;
    }
}

